/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape.view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.ClosableTabComponent;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import xapps.api.vtools.ParamSetFormForAFew;
import xtools.api.param.DirParam;
import xtools.api.param.Param;
import xtools.api.param.ReportCacheChooserParam;

public class EnrichmentMapInputPanel
extends AbstractViewer {
    public static final String NAME = "EnrichmentMapVisualizationWidget";
    public static final Icon ICON = JarResources.getIcon("enrichmentmap_logo.png");
    private ReportCacheChooserParam fReportParam;
    private DirParam fDirParam;
    private JComponent fFiller;
    private EnrichmentMapInputPanel fInstance = this;
    private JTabbedPane sharedTabbedPane;

    public EnrichmentMapInputPanel() {
        super(NAME, ICON, "Enrichment Map Visualization");
        this.jbInit();
    }

    private void jbInit() {
        JPanel buttons = new JPanel();
        JButton bClear = new JButton("Clear");
        bClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnrichmentMapInputPanel.this.fReportParam.getSelectionComponent().setValue("");
                ((GDirFieldPlusChooser)EnrichmentMapInputPanel.this.fDirParam.getSelectionComponent()).getTextField().setText("");
            }
        });
        JButton bBuild = new JButton("Load GSEA Results");
        bBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EnrichmentMapInputPanel.this.fReportParam.isSpecified() && EnrichmentMapInputPanel.this.fDirParam.isSpecified()) {
                    Application.getWindowManager().showMessage("Both cache and a brows'ed directory were specified. Only 1 can be specified. Delete one and try again");
                } else if (!EnrichmentMapInputPanel.this.fReportParam.isSpecified() && !EnrichmentMapInputPanel.this.fDirParam.isSpecified()) {
                    Application.getWindowManager().showMessage("No GSEA result folder was specified. Specify one and try again");
                } else {
                    SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected Object doInBackground() throws Exception {
                            try {
                                Application.getWindowManager().getRootFrame().setCursor(Cursor.getPredefinedCursor(3));
                                String current_results = "";
                                current_results = EnrichmentMapInputPanel.this.fReportParam.isSpecified() ? EnrichmentMapInputPanel.this.fReportParam.getValue().toString() : EnrichmentMapInputPanel.this.fDirParam.getValue().toString();
                                String[] datasets = current_results.split(",");
                                boolean first = false;
                                if (EnrichmentMapInputPanel.this.sharedTabbedPane == null) {
                                    first = true;
                                    EnrichmentMapInputPanel.this.sharedTabbedPane = new JTabbedPane();
                                }
                                try {
                                    EnrichmentMapParameterPanel new_panel = new EnrichmentMapParameterPanel(datasets);
                                    JScrollPane scrollablePanel = new JScrollPane(new_panel);
                                    EnrichmentMapInputPanel.this.sharedTabbedPane.addTab(null, scrollablePanel);
                                    EnrichmentMapInputPanel.this.sharedTabbedPane.setTabComponentAt(EnrichmentMapInputPanel.this.sharedTabbedPane.getTabCount() - 1, new ClosableTabComponent(EnrichmentMapInputPanel.this.sharedTabbedPane, "EM Analysis", null));
                                    EnrichmentMapInputPanel.this.sharedTabbedPane.setSelectedComponent(scrollablePanel);
                                }
                                catch (Throwable t) {
                                    System.out.println("unable to initialize interface");
                                }
                                if (first) {
                                    EnrichmentMapInputPanel.this.fInstance.remove(EnrichmentMapInputPanel.this.fFiller);
                                    EnrichmentMapInputPanel.this.fInstance.add((Component)EnrichmentMapInputPanel.this.sharedTabbedPane, "Center");
                                }
                                EnrichmentMapInputPanel.this.fInstance.revalidate();
                            }
                            catch (Throwable t) {
                                Application.getWindowManager().showError("Trouble loading enrichment database", t);
                            }
                            finally {
                                Application.getWindowManager().getRootFrame().setCursor(Cursor.getPredefinedCursor(0));
                            }
                            return null;
                        }
                    };
                    worker.execute();
                }
            }
        });
        this.fReportParam = new ReportCacheChooserParam("Select a GSEA result from the application cache");
        this.fDirParam = new DirParam("dir", "[ OR ] Locate a GSEA result folder from the file system", "[ OR ] Locate a GSEA report folder from the file system", false);
        Param[] params = new Param[]{this.fReportParam, this.fDirParam};
        StringBuffer colStr = EnrichmentMapInputPanel._createColStr();
        StringBuffer rowStr = EnrichmentMapInputPanel._createRowStr(params);
        PanelBuilder builder = ParamSetFormForAFew.createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        int rowcnt = 3;
        for (int i = 0; i < params.length; ++i) {
            GFieldPlusChooser chooser = params[i].getSelectionComponent();
            if (params[i].isFileBased() && chooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)chooser).getTextField().setBackground(ParamSetFormForAFew.LIGHT_GREEN);
            }
            JLabel label = new JLabel(params[i].getHtmlLabel_v3());
            ParamSetFormForAFew.enableToolTips(label, params[i]);
            builder.add((Component)label, cc.xy(1, rowcnt));
            builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
            rowcnt += 2;
        }
        builder.add((Component)new JLabel(""), cc.xy(1, rowcnt));
        buttons.add(bClear);
        buttons.add(bBuild);
        builder.add((Component)buttons, cc.xy(3, rowcnt));
        JPanel paramPanel = builder.getPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)paramPanel, "North");
        this.fFiller = GuiHelper.createWaitingPlaceholder();
        this.add((Component)this.fFiller, "Center");
        this.revalidate();
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("220dlu,      4dlu,        200dlu,   4dlu,  4dlu");
    }

    private static StringBuffer _createRowStr(Param[] params) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 10dlu,");
        for (int i = 0; i < params.length + 1; ++i) {
            rowStr.append("pref, 5dlu");
            if (params.length == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }
}

