/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.MSigDBSpecies;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Versioned;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;
import org.genepattern.uiutil.FTPFile;
import org.genepattern.uiutil.FTPList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;
import xtools.api.param.ChooserHelper;
import xtools.api.param.Validator;

public class GeneSetMatrixChooserWindow {
    private static final Logger klog = LoggerFactory.getLogger(GeneSetMatrixChooserWindow.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] showDirectlyWithModels() {
        String[] onTheFlyGenes;
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)tabbedPane, "Center");
        Action helpAction = JarResources.createDataFormatAction("#gmx");
        BrowserAction infoAction = new BrowserAction("MSigDB Collections", "MSigDB Collections Info", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/msigdb/");
        DialogDescriptor desc = Application.getWindowManager().createDialogDescriptor("Select a gene set", wrapper, helpAction, infoAction, true);
        JList<FTPFile> humanFTPFileJList = new JList<FTPFile>();
        JList<FTPFile> mouseFTPFileJList = new JList<FTPFile>();
        if (XPreferencesFactory.kOnlineMode.getBoolean()) {
            FTPList ftpList = null;
            try {
                ftpList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword());
                try {
                    FTPFile[] humanFTPFiles = ChooserHelper.retrieveFTPFiles(ftpList, ".symbols.gmt", MSigDBSpecies.Human, GseaWebResources.getGseaFTPServerGeneSetsDir(MSigDBSpecies.Human));
                    FTPFile[] mouseFTPFiles = ChooserHelper.retrieveFTPFiles(ftpList, ".symbols.gmt", MSigDBSpecies.Mouse, GseaWebResources.getGseaFTPServerGeneSetsDir(MSigDBSpecies.Mouse));
                    ChooserHelper.populateFTPModel(humanFTPFiles, humanFTPFileJList, desc, new ComparatorFactory.FTPFileByVersionComparator("h"), 2);
                    ChooserHelper.populateFTPModel(mouseFTPFiles, mouseFTPFileJList, desc, new ComparatorFactory.FTPFileByVersionComparator("mh"), 2);
                    tabbedPane.addTab("Human Collection (MSigDB)", new JScrollPane(humanFTPFileJList));
                    tabbedPane.addTab("Mouse Collection (MSigDB)", new JScrollPane(mouseFTPFileJList));
                }
                finally {
                    if (ftpList != null) {
                        ftpList.quit();
                    }
                }
            }
            catch (Exception ex) {
                klog.error(ex.getMessage(), (Throwable)ex);
                tabbedPane.addTab("Human Collection (MSigDB)", new JScrollPane(ChooserHelper.createErrorMessageDisplay(ex)));
                tabbedPane.addTab("Mouse Collection (MSigDB)", new JScrollPane(ChooserHelper.createErrorMessageDisplay(ex)));
            }
        } else {
            tabbedPane.addTab("Human Collection (MSigDB)", new JScrollPane(ChooserHelper.createOfflineMessageDisplay()));
            tabbedPane.addTab("Mouse Collection (MSigDB)", new JScrollPane(ChooserHelper.createOfflineMessageDisplay()));
        }
        NonFTPGeneSetsRenderer defaultRenderer = new NonFTPGeneSetsRenderer();
        JList<Object> localGeneSetMatrixJList = new JList<Object>(ObjectBindery.getModel(GeneSetMatrix.class));
        localGeneSetMatrixJList.setCellRenderer(defaultRenderer);
        localGeneSetMatrixJList.setSelectionMode(2);
        tabbedPane.addTab("Local GMX/GMT", new JScrollPane(localGeneSetMatrixJList));
        desc.enableDoubleClickableJList(localGeneSetMatrixJList);
        JList<Object> localGeneSetJList = new JList<Object>(ObjectBindery.getModel(GeneSet.class));
        localGeneSetJList.setCellRenderer(defaultRenderer);
        localGeneSetJList.setSelectionMode(2);
        tabbedPane.addTab("Local GRP Gene sets", new JScrollPane(localGeneSetJList));
        desc.enableDoubleClickableJList(localGeneSetJList);
        JList<Object> localMatrixSubsetsJList = new JList<Object>(ObjectBindery.getHackAuxGeneSetsBoxModel());
        localMatrixSubsetsJList.setCellRenderer(defaultRenderer);
        localMatrixSubsetsJList.setSelectionMode(2);
        tabbedPane.addTab("Subsets", new JScrollPane(localMatrixSubsetsJList));
        desc.enableDoubleClickableJList(localMatrixSubsetsJList);
        JTextArea taGenes = new JTextArea();
        taGenes.setText("");
        taGenes.setBorder(BorderFactory.createTitledBorder("Make an 'on-the-fly' gene set: Enter features below, one per line"));
        tabbedPane.addTab("Text entry", new JScrollPane(taGenes));
        BooleanSupplier warningChecker = () -> {
            ArrayList selectedItems = new ArrayList(humanFTPFileJList.getSelectedValuesList());
            selectedItems.addAll(mouseFTPFileJList.getSelectedValuesList());
            selectedItems.addAll(localGeneSetMatrixJList.getSelectedValuesList());
            selectedItems.addAll(localGeneSetJList.getSelectedValuesList());
            selectedItems.addAll(localMatrixSubsetsJList.getSelectedValuesList());
            if (selectedItems.isEmpty()) {
                return true;
            }
            MSigDBVersion first = ((Versioned)selectedItems.remove(0)).getMSigDBVersion();
            boolean allUnknown = first.isUnknownVersion();
            boolean allKnown = !first.isUnknownVersion();
            allKnown &= StringUtils.isBlank((CharSequence)taGenes.getText());
            for (Versioned item : selectedItems) {
                MSigDBVersion currVer = item.getMSigDBVersion();
                if (!currVer.isUnknownVersion()) {
                    if (!first.equals(currVer)) {
                        return false;
                    }
                    allUnknown = false;
                    allKnown &= true;
                    continue;
                }
                allUnknown &= true;
                allKnown = false;
            }
            return allUnknown || allKnown;
        };
        Supplier<Errors> warningMsgBuilder = () -> {
            Errors warnings = new Errors("Mixed MSigDB versions detected");
            warnings.add("Selecting collections from multiple MSigDB versions");
            warnings.add("may result in omitted genes and is not recommended.\n");
            warnings.add("NOTE: another tab may have a selection.");
            warnings.add(ChooserHelper.DESELECT_INSTRUCTIONS);
            warnings.add("\nClick Cancel to change the selection or OK to keep it.");
            return warnings;
        };
        Validator warningValidator = new Validator(warningChecker, warningMsgBuilder);
        desc.setWarningValidator(warningValidator);
        BooleanSupplier errorChecker = () -> {
            ArrayList selectedItems = new ArrayList(humanFTPFileJList.getSelectedValuesList());
            selectedItems.addAll(mouseFTPFileJList.getSelectedValuesList());
            selectedItems.addAll(localGeneSetMatrixJList.getSelectedValuesList());
            selectedItems.addAll(localGeneSetJList.getSelectedValuesList());
            selectedItems.addAll(localMatrixSubsetsJList.getSelectedValuesList());
            selectedItems.removeIf(new Predicate<Versioned>(){

                @Override
                public boolean test(Versioned item) {
                    return item.getMSigDBVersion().isUnknownVersion();
                }
            });
            if (selectedItems.isEmpty()) {
                return true;
            }
            MSigDBVersion first = ((Versioned)selectedItems.remove(0)).getMSigDBVersion();
            for (Versioned item : selectedItems) {
                if (first.getMsigDBSpecies() == item.getMSigDBVersion().getMsigDBSpecies()) continue;
                return false;
            }
            return true;
        };
        Supplier<Errors> errorMsgBuilder = () -> {
            Errors errors = new Errors("Multiple species selected");
            errors.add("Multiple species selections are not allowed.\n");
            errors.add("Is there a selection on another tab?");
            errors.add(ChooserHelper.DESELECT_INSTRUCTIONS);
            return errors;
        };
        Validator errorValidator = new Validator(errorChecker, errorMsgBuilder);
        desc.setErrorValidator(errorValidator);
        desc.setDisplayWider();
        int res = desc.show();
        if (res == 2) {
            return null;
        }
        ArrayList<String> allValues = new ArrayList<String>();
        for (FTPFile ftpFile : humanFTPFileJList.getSelectedValuesList()) {
            allValues.add(ftpFile.getPath());
        }
        for (FTPFile ftpFile : mouseFTPFileJList.getSelectedValuesList()) {
            allValues.add(ftpFile.getPath());
        }
        for (GeneSetMatrix geneSetMatrix : localGeneSetMatrixJList.getSelectedValuesList()) {
            allValues.add(ParserFactory.getCache().getSourcePath(geneSetMatrix));
        }
        for (GeneSet geneSet : localGeneSetJList.getSelectedValuesList()) {
            allValues.add(ParserFactory.getCache().getSourcePath(geneSet));
        }
        for (GeneSet geneSet : localMatrixSubsetsJList.getSelectedValuesList()) {
            allValues.add(ParserFactory.getCache().getSourcePath(geneSet));
        }
        String onTheFlyText = taGenes.getText();
        if (StringUtils.isNotBlank((CharSequence)onTheFlyText) && (onTheFlyGenes = ParseUtils.string2strings(onTheFlyText, "\t\n")).length != 0) {
            GeneSet gset = new GeneSet("from_text_entry_", onTheFlyGenes);
            try {
                ParserFactory.save(gset, File.createTempFile(gset.getName(), ".grp"));
                allValues.add(ParserFactory.getCache().getSourcePath(gset));
            }
            catch (Throwable t) {
                klog.error(t.getMessage(), t);
            }
        }
        return allValues.toArray(new String[allValues.size()]);
    }

    public static class NonFTPGeneSetsRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PersistentObject) {
                PersistentObject pob = (PersistentObject)value;
                if (pob.getQuickInfo() != null) {
                    StringBuffer buf = new StringBuffer("<html><body>").append(pob.getName());
                    buf.append("<font color=#666666> [").append(pob.getQuickInfo()).append(']').append("</font></html></body>");
                    this.setText(buf.toString());
                } else {
                    this.setText(pob.getName());
                }
                if (ParserFactory.getCache().isCached(pob)) {
                    File f = ParserFactory.getCache().getSourceFile(pob);
                    this.setToolTipText(f.getAbsolutePath());
                } else {
                    this.setToolTipText("Unknown origins of file");
                }
            } else if (value instanceof File) {
                this.setText(((File)value).getName());
                this.setIcon(DataFormat.getIcon(value));
                this.setToolTipText(((File)value).getAbsolutePath());
            }
            return this;
        }
    }
}

