/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.commons.lang3.StringUtils;
import xtools.api.param.AbstractParam;
import xtools.api.param.Param;
import xtools.api.param.ParamHelper;

public class IntegerParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    public IntegerParam(String name, String englishName, String desc, int def_andonly_hint, boolean reqd) {
        super(name, englishName, Integer.class, desc, (Object)def_andonly_hint, reqd);
    }

    public IntegerParam(String name, String englishName, String desc, int def_andonly_hint, boolean reqd, Param.Type type) {
        super(name, englishName, Integer.class, desc, (Object)def_andonly_hint, reqd, type);
    }

    public IntegerParam(String name, String englishName, String desc, int def, int[] hintsanddef, boolean reqd) {
        super(name, englishName, Integer.class, desc, (Object)def, (Object[])IntegerParam.toInts(hintsanddef), reqd);
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        if (value == null || value instanceof Integer) {
            return value;
        }
        if (value instanceof String) {
            if (StringUtils.isBlank((CharSequence)value.toString())) {
                if (!this.isReqd()) {
                    return this.getDefault();
                }
                throw new IllegalArgumentException("Parameter '" + this.getNameEnglish() + "' is required");
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Parameter '" + this.getNameEnglish() + "' had value '" + value.toString() + "'. Must be a valid integer.", nfe);
            }
        }
        throw new IllegalArgumentException("Invalid type for Parameter '" + this.getNameEnglish() + ", only Integer accepted. Specified: " + String.valueOf(value) + " class: " + String.valueOf(value.getClass()));
    }

    public int getIValue() {
        Object val = this.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (Integer)val;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(true, (ActionListener)this, this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue(this.cbOptions.getComboBox().getSelectedItem());
    }
}

