/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.uiutil.CenteredDialog;
import org.genepattern.uiutil.UIUtil;

public class FindAction
extends AbstractAction {
    private JTable table;
    private SearchDialog searchDialog;
    private int highlightColumn;
    private Frame parent;
    private FindModel findModel;

    public FindAction(Frame parent, JTable table, IExpressionData data, int highlightColumn) {
        this(parent, table);
        this.findModel = new IExpressionDataModel(data);
        this.highlightColumn = highlightColumn;
    }

    private FindAction(Frame parent, JTable table) {
        super("Find...");
        this.parent = parent;
        this.table = table;
        KeyStroke ks = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.putValue("AcceleratorKey", ks);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog();
        }
        this.searchDialog.setVisible(true);
    }

    private static class IExpressionDataModel
    implements FindModel {
        private IExpressionData data;

        public IExpressionDataModel(IExpressionData data) {
            this.data = data;
        }

        @Override
        public Object getValue(int row) {
            return this.data.getRowName(row);
        }
    }

    private static interface FindModel {
        public Object getValue(int var1);
    }

    class SearchDialog
    extends CenteredDialog {
        public SearchDialog() {
            super(FindAction.this.parent);
            this.setTitle("Find");
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.setVisible(false);
                }
            });
            JPanel searchPanel = new JPanel(new BorderLayout());
            JLabel searchTermLabel = new JLabel("Search features for:");
            final JTextField searchField = new JTextField(20);
            searchPanel.add((Component)searchTermLabel, "North");
            searchPanel.add((Component)searchField, "Center");
            final JCheckBox caseCheckBox = new JCheckBox("Match case");
            JPanel optionsPanel = new JPanel();
            optionsPanel.add(caseCheckBox);
            JButton findButton = new JButton("Find Next");
            this.getRootPane().setDefaultButton(findButton);
            findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int startRow;
                    int i;
                    boolean caseSensitive = caseCheckBox.isSelected();
                    String searchTerm = searchField.getText().trim();
                    if (searchTerm == null || searchTerm.equals("")) {
                        SearchDialog.this.notFound();
                        return;
                    }
                    if (!caseSensitive) {
                        searchTerm = searchTerm.toLowerCase();
                    }
                    boolean found = false;
                    int row = -1;
                    int rows = FindAction.this.table.getRowCount();
                    for (i = startRow = FindAction.this.table.getSelectedRow() + 1; i < rows && !found; ++i) {
                        String value = String.valueOf(FindAction.this.findModel.getValue(i));
                        if (!caseSensitive) {
                            value = value.toLowerCase();
                        }
                        if (value.indexOf(searchTerm) < 0) continue;
                        row = i;
                        found = true;
                    }
                    if (!found) {
                        for (i = 0; i < startRow && !found; ++i) {
                            String value = String.valueOf(FindAction.this.findModel.getValue(i));
                            if (!caseSensitive) {
                                value = value.toLowerCase();
                            }
                            if (value.indexOf(searchTerm) < 0) continue;
                            row = i;
                            found = true;
                        }
                    }
                    if (!found) {
                        SearchDialog.this.notFound();
                    } else {
                        FindAction.this.table.changeSelection(row, FindAction.this.highlightColumn, false, false);
                    }
                }
            });
            JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
            buttonPanel.add(findButton);
            buttonPanel.add(closeButton);
            Container c = this.getContentPane();
            c.setLayout(new BorderLayout());
            JPanel temp = new JPanel();
            temp.add(searchPanel);
            temp.add(buttonPanel);
            c.add((Component)temp, "Center");
            c.add((Component)optionsPanel, "South");
            this.pack();
            searchField.requestFocus();
            this.setResizable(false);
        }

        private void notFound() {
            UIUtil.showMessageDialog(this, "The search term you entered was not found.");
        }
    }
}

