/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.la4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.la4j.La4JDenseDoubleMatrix2DFactory;

public class La4JDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = 904914110868813155L;
    public static final La4JDenseDoubleMatrix2DFactory Factory = new La4JDenseDoubleMatrix2DFactory();
    private transient Basic2DMatrix matrix;

    public La4JDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new Basic2DMatrix(rows, columns);
    }

    public La4JDenseDoubleMatrix2D(Basic2DMatrix matrix) {
        super((long)matrix.rows(), (long)matrix.columns());
        this.matrix = matrix;
    }

    public La4JDenseDoubleMatrix2D(org.ujmp.core.Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        this.matrix = new Basic2DMatrix((int)source.getRowCount(), (int)source.getColumnCount());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    public double getDouble(long row, long column) {
        return this.matrix.get(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    public void setDouble(double value, long row, long column) {
        this.matrix.set(MathUtil.longToInt(row), MathUtil.longToInt(column), value);
    }

    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    public org.ujmp.core.Matrix plus(double value) {
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.add(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix m) {
        if (m instanceof La4JDenseDoubleMatrix2D) {
            La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.add((Matrix)((La4JDenseDoubleMatrix2D)m).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m);
    }

    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof La4JDenseDoubleMatrix2D) {
            La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.multiply((Matrix)((La4JDenseDoubleMatrix2D)m).matrix));
            return result;
        }
        return super.mtimes(m);
    }

    public org.ujmp.core.Matrix minus(double value) {
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.subtract(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public org.ujmp.core.Matrix minus(org.ujmp.core.Matrix m) {
        if (m instanceof La4JDenseDoubleMatrix2D) {
            La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.subtract((Matrix)((La4JDenseDoubleMatrix2D)m).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m);
    }

    public org.ujmp.core.Matrix divide(double value) {
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.divide(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public org.ujmp.core.Matrix times(double value) {
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.multiply(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public org.ujmp.core.Matrix transpose() {
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)this.matrix.transpose());
        return result;
    }

    public org.ujmp.core.Matrix[] lu() {
        Matrix[] temp = this.matrix.withDecompositor(LinearAlgebra.DecompositorFactory.LU).decompose();
        org.ujmp.core.Matrix[] result = new org.ujmp.core.Matrix[]{new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[0]), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[1]), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[2].toDenseMatrix())};
        return result;
    }

    public org.ujmp.core.Matrix[] svd() {
        Matrix[] temp = this.matrix.withDecompositor(LinearAlgebra.DecompositorFactory.SVD).decompose();
        org.ujmp.core.Matrix[] result = new org.ujmp.core.Matrix[]{new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[0]), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[1]), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[2])};
        return result;
    }

    public org.ujmp.core.Matrix chol() {
        Matrix[] temp = this.matrix.withDecompositor(LinearAlgebra.DecompositorFactory.CHOLESKY).decompose();
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[0]);
        return result;
    }

    public org.ujmp.core.Matrix inv() {
        Matrix temp = this.matrix.withInverter(LinearAlgebra.InverterFactory.SMART).inverse();
        La4JDenseDoubleMatrix2D result = new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp);
        return result;
    }

    public org.ujmp.core.Matrix[] qr() {
        Matrix[] temp = this.matrix.withDecompositor(LinearAlgebra.DecompositorFactory.QR).decompose();
        org.ujmp.core.Matrix[] result = new org.ujmp.core.Matrix[]{new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[0]), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[1])};
        return result;
    }

    public org.ujmp.core.Matrix[] eig() {
        Matrix[] temp = this.matrix.withDecompositor(LinearAlgebra.DecompositorFactory.EIGEN).decompose();
        org.ujmp.core.Matrix[] result = new org.ujmp.core.Matrix[]{new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[0].toDenseMatrix()), new La4JDenseDoubleMatrix2D((Basic2DMatrix)temp[1].toDenseMatrix())};
        return result;
    }

    public La4JDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        byte[] binary = (byte[])s.readObject();
        this.matrix = Basic2DMatrix.fromBinary((byte[])binary);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.matrix.toBinary());
    }
}

