/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.longmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.longmatrix.calculation.AbstractLongCalculation;
import org.ujmp.core.longmatrix.impl.DefaultSparseLongMatrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public class DocTerm
extends AbstractLongCalculation {
    private static final long serialVersionUID = 9021699761386822606L;
    private MapMatrix<String, Long> wordMapping = null;
    private Matrix result = null;

    public DocTerm(Matrix m) {
        super(m);
    }

    public long getLong(long ... coordinates) {
        if (this.result == null) {
            this.result = this.calculate();
        }
        return this.result.getAsLong(coordinates);
    }

    public long[] getSize() {
        if (this.result == null) {
            this.result = this.calculate();
        }
        return this.result.getSize();
    }

    public boolean isSparse() {
        return true;
    }

    private Matrix calculate() {
        this.wordMapping = new DefaultMapMatrix<String, Long>();
        Matrix m = this.getSource();
        for (long[] c : m.availableCoordinates()) {
            String[] words;
            String s = m.getAsString(c);
            if (s == null) continue;
            for (String w : words = s.split("\\s+")) {
                Long i;
                if (w.length() == 0 || (i = (Long)this.wordMapping.get(w)) != null) continue;
                this.wordMapping.put(w, this.wordMapping.getRowCount());
            }
        }
        this.result = new DefaultSparseLongMatrix(m.getRowCount(), this.wordMapping.getRowCount());
        long rowCount = m.getRowCount();
        long colCount = m.getColumnCount();
        for (long row = 0L; row < rowCount; ++row) {
            for (long col = 0L; col < colCount; ++col) {
                String[] words;
                String string = m.getAsString(row, col);
                if (string == null || string.length() <= 0) continue;
                for (String w : words = string.split("[\\s]+")) {
                    if (w.length() == 0) continue;
                    long i = (Long)this.wordMapping.get(w);
                    int count = this.result.getAsInt(row, i);
                    this.result.setAsInt(++count, row, i);
                }
            }
        }
        return this.result;
    }
}

