/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.PersistentObject;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class AuxUtils {
    private AuxUtils() {
    }

    public static String getAuxNameOnlyIncludingHash(String path) {
        StringTokenizer tok = new StringTokenizer(path, "#");
        tok.nextToken();
        return "#" + tok.nextToken();
    }

    public static String getAuxNameOnlyNoHash(PersistentObject pob) {
        if (pob == null) {
            throw new IllegalArgumentException("Param pob cannot be null");
        }
        return AuxUtils.getAuxNameOnlyNoHash(pob.getName());
    }

    public static String getAuxNameOnlyNoHash(String fullPathOrNameMaybeWithAux) {
        StringTokenizer tok = new StringTokenizer(fullPathOrNameMaybeWithAux, "#");
        String nonaux = fullPathOrNameMaybeWithAux;
        while (tok.hasMoreTokens()) {
            nonaux = tok.nextToken();
        }
        return nonaux;
    }

    public static String getBaseNameOnly(String fullPathOrNameMaybeWithAux) {
        StringTokenizer tok = new StringTokenizer(fullPathOrNameMaybeWithAux, "#");
        return tok.nextToken();
    }

    public static File getBaseFileFromFullPath(String fullPathMaybeWithAux) {
        if (fullPathMaybeWithAux == null) {
            throw new IllegalArgumentException("Parameter fullPathMaybeWithAux cannot be null");
        }
        if (fullPathMaybeWithAux.length() == 0) {
            throw new IllegalArgumentException("Parameter fullPathMaybeWithAux cannot be empty");
        }
        StringTokenizer tok = new StringTokenizer(fullPathMaybeWithAux, "#@");
        File f = tok.countTokens() == 1 ? new File(fullPathMaybeWithAux) : new File(tok.nextToken());
        return f;
    }

    public static File getBaseFileFromAuxFile(File auxfile) {
        return AuxUtils.getBaseFileFromFullPath(auxfile.getPath());
    }

    public static String getBasePathFromAuxPath(String fullPathMaybeWithAux) {
        return AuxUtils.getBaseFileFromFullPath(fullPathMaybeWithAux).getPath();
    }

    public static String getBaseStringFromAux(String auxname_or_auxpath) {
        StringTokenizer tok = new StringTokenizer(auxname_or_auxpath, "#");
        if (tok.countTokens() == 1) {
            return auxname_or_auxpath;
        }
        return tok.nextToken();
    }

    public static boolean isAux(String aux_name_or_path) {
        StringTokenizer tok = new StringTokenizer(aux_name_or_path, "#");
        if (tok.countTokens() == 1) {
            return false;
        }
        if (tok.countTokens() >= 2) {
            return true;
        }
        throw new RuntimeException("Cannot process files named # tokens found: " + tok.countTokens() + " aux_name_or_path>" + aux_name_or_path + "<");
    }

    public static boolean isAuxFile(File file) {
        if (StringUtils.contains((CharSequence)file.getAbsolutePath(), (CharSequence)"#")) {
            return true;
        }
        return StringUtils.contains((CharSequence)file.getAbsolutePath(), (CharSequence)"@");
    }
}

