/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.objects.PersistentObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObject
implements PersistentObject {
    private String fName;
    private String fNameEnglish;
    private Id fId;
    private StringBuilder fComment;
    private List<String> warnings = new ArrayList<String>();
    protected transient Logger log;
    private boolean fInited;
    private Properties prp;

    protected AbstractObject(String name) {
        this.initialize(Id.createId(), name);
    }

    protected AbstractObject() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    protected void initialize(Id id, String name) {
        this.initialize(id, name, null);
    }

    protected void initialize(Id id, String name, String nameEnglish) {
        if (this.fInited) {
            throw new IllegalStateException("Already initialized. disp name " + name);
        }
        if (id == null) {
            throw new NullPointerException("Parameter id cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Parameter name cannot be null");
        }
        this.log = LoggerFactory.getLogger(this.getClass());
        this.fId = id;
        this.fName = this.removeExtension(name);
        if (nameEnglish != null) {
            this.fNameEnglish = this.removeExtension(nameEnglish);
        }
        this.fInited = true;
    }

    protected void initialize(String name) {
        this.initialize(Id.createId(), name);
    }

    protected void initialize(String name, String nameEnglish) {
        this.initialize(Id.createId(), name, nameEnglish);
    }

    protected boolean isInited() {
        return this.fInited;
    }

    private String removeExtension(String name) {
        return name;
    }

    @Override
    public Id getId() {
        this.checkInit();
        return this.fId;
    }

    private void checkInit() {
        if (!this.fInited) {
            throw new IllegalStateException("Uninitialized: " + this.fName);
        }
    }

    @Override
    public String getName() {
        this.checkInit();
        return this.fName;
    }

    @Override
    public String getNameEnglish() {
        this.checkInit();
        return this.fNameEnglish;
    }

    @Override
    public String getComment() {
        return this.fComment == null ? "" : this.fComment.toString();
    }

    @Override
    public void addComment(String comment) {
        if (this.fComment == null) {
            this.fComment = new StringBuilder(comment);
        } else {
            this.fComment.append("\n").append(comment);
        }
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    protected void setName(String newname) {
        if (newname == null) {
            this.log.warn("Ignoring rename request as newname is null");
        } else {
            this.fName = newname;
        }
    }

    public void setProperty(String key, String value) {
        if (this.prp == null) {
            this.prp = new Properties();
        }
        this.prp.put(key, value);
    }
}

