/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.parsers.ParserWorker;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.viewers.DatasetViewerAction;
import edu.mit.broad.genome.viewers.GeneSetMatrixViewerAction;
import edu.mit.broad.genome.viewers.GeneSetViewerAction;
import edu.mit.broad.genome.viewers.PhenotypeViewerAction;
import edu.mit.broad.genome.viewers.RankedListViewerAction;
import edu.mit.broad.genome.viewers.ReportViewerAction;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.actions.ChipViewerAction;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.actions.FilesAction;
import edu.mit.broad.xbench.actions.ObjectAction;
import edu.mit.broad.xbench.actions.PobActions;
import edu.mit.broad.xbench.actions.ProxyFileAction;
import edu.mit.broad.xbench.actions.ProxyFileObjectAction;
import edu.mit.broad.xbench.actions.ProxyObjectAction;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.FileBrowserAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetsAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetRemoveDuplicatesAction;
import edu.mit.broad.xbench.actions.misc_actions.LoadAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GseaActionRegistry {
    private final Map<String, PobActions> fExtActionsMap = new HashMap<String, PobActions>();
    private static final Logger klog = LoggerFactory.getLogger(GseaActionRegistry.class);
    private static PobActions COMMON_ACTIONS = new PobActions(new XAction[]{new LoadAction(), null, new OsExplorerAction()});
    private static PobActions GEX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new DatasetViewerAction()});
    private static PobActions CHIP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ChipViewerAction()});
    private static PobActions GRP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetViewerAction(), null, new GeneSetRemoveDuplicatesAction()});
    private static PobActions CLS_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new PhenotypeViewerAction()});
    private static PobActions RNK_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new RankedListViewerAction()});
    private static PobActions GMX_ACTIONS;
    private static PobActions GMT_ACTIONS;
    private static PobActions RPT_ACTIONS;
    private static GseaActionRegistry kSingleton;

    public static GseaActionRegistry getInstance() {
        if (kSingleton == null) {
            kSingleton = new GseaActionRegistry();
        }
        return kSingleton;
    }

    private GseaActionRegistry() {
        this.fExtActionsMap.put("res", GEX_ACTIONS);
        this.fExtActionsMap.put("txt", GEX_ACTIONS);
        this.fExtActionsMap.put("pcl", GEX_ACTIONS);
        this.fExtActionsMap.put("gct", GEX_ACTIONS);
        this.fExtActionsMap.put("cls", CLS_ACTIONS);
        this.fExtActionsMap.put("grp", GRP_ACTIONS);
        this.fExtActionsMap.put("gmx", GMX_ACTIONS);
        this.fExtActionsMap.put("gmt", GMT_ACTIONS);
        this.fExtActionsMap.put("def", COMMON_ACTIONS);
        this.fExtActionsMap.put("rpt", RPT_ACTIONS);
        this.fExtActionsMap.put("chip", CHIP_ACTIONS);
        this.fExtActionsMap.put("rnk", RNK_ACTIONS);
    }

    private static PobActions _addCommon(XAction[] customs) {
        ArrayList<XAction> all = new ArrayList<XAction>();
        int cnt = 0;
        int i = 0;
        while (i < customs.length) {
            all.add(customs[i]);
            ++i;
            ++cnt;
        }
        if (cnt != 0) {
            all.add(null);
        }
        for (i = 0; i < GseaActionRegistry.COMMON_ACTIONS.allActions.length; ++i) {
            all.add(GseaActionRegistry.COMMON_ACTIONS.allActions[i]);
        }
        return new PobActions(all.toArray(new XAction[all.size()]));
    }

    private PobActions lookupActions(Object obj) {
        String name = "";
        if (obj instanceof Dataset || name.endsWith("res") || name.endsWith("gct") || name.endsWith("pcl") || name.endsWith("txt")) {
            return GEX_ACTIONS;
        }
        if (obj instanceof GeneSet || name.endsWith("grp")) {
            return GRP_ACTIONS;
        }
        if (obj instanceof GeneSetMatrix || name.endsWith("gmx") || name.endsWith("gmt")) {
            return GMX_ACTIONS;
        }
        if (obj instanceof Report || name.endsWith("rpt")) {
            return RPT_ACTIONS;
        }
        if (obj instanceof Chip || name.endsWith("chip")) {
            return CHIP_ACTIONS;
        }
        if (obj instanceof Template || name.endsWith("cls")) {
            return CLS_ACTIONS;
        }
        if (obj instanceof RankedList) {
            return RNK_ACTIONS;
        }
        return new PobActions();
    }

    public boolean runDefaultAction(Object obj) {
        if (obj instanceof File || obj instanceof File[]) {
            String filename;
            File[] files = obj instanceof File ? new File[]{(File)obj} : (File[])obj;
            if (files.length == 1 && (StringUtils.endsWithIgnoreCase((CharSequence)(filename = files[0].getName()), (CharSequence)"html") || StringUtils.endsWithIgnoreCase((CharSequence)filename, (CharSequence)"tsv"))) {
                URI fileURI = files[0].toURI();
                try {
                    fileURI = new URI(fileURI.getScheme(), "", fileURI.getPath(), null, null);
                    Desktop.getDesktop().browse(fileURI);
                }
                catch (Exception e) {
                    Application.getWindowManager().showError(e.toString());
                }
                return true;
            }
            new ParserWorker(files).execute();
            return true;
        }
        return false;
    }

    public JPopupMenu createPopup(File file) {
        String ext = NamingConventions.getExtension(file);
        PobActions obj = this.fExtActionsMap.get(ext);
        if (obj == null) {
            JPopupMenu p = new JPopupMenu();
            if (!file.isDirectory()) {
                p.add(new FileBrowserAction(file));
            }
            p.add(new OsExplorerAction(file));
            return p;
        }
        PobActions da = obj;
        return this._createPopup(da.allActions, file);
    }

    public JPopupMenu createPopup(Object obj) {
        if (obj instanceof File) {
            return this.createPopup((File)obj);
        }
        PobActions pa = this.lookupActions(obj);
        XAction[] actions = pa.allActions;
        if (actions != null && actions.length > 0) {
            return this.createPopupForObject(actions, obj);
        }
        return new JPopupMenu();
    }

    public JPopupMenu createPopupForObject(XAction[] actions, Object obj) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                list.add(new JSeparator());
                continue;
            }
            try {
                list.add(new JMenuItem(this.createAction(actions[i], obj)));
                continue;
            }
            catch (Throwable e) {
                klog.error("Error making popup", e);
                list.add(new JMenuItem("Error making popup: " + String.valueOf(e)));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            menu.add((Component)list.get(i));
        }
        return menu;
    }

    private JPopupMenu _createPopup(XAction[] actions, File file) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        if (actions == null) {
            return menu;
        }
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                list.add(new JSeparator());
                continue;
            }
            try {
                JMenuItem item = new JMenuItem(this.createAction(actions[i], file));
                list.add(item);
                continue;
            }
            catch (Throwable e) {
                klog.error(e.getMessage(), e);
                list.add(new JMenuItem("Error making popup: " + String.valueOf(e)));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            menu.add((Component)list.get(i));
        }
        return menu;
    }

    public XAction createAction(XAction action, Object data) throws Exception {
        if (action instanceof FileObjectAction) {
            return new ProxyFileObjectAction((FileObjectAction)action, data);
        }
        if (action instanceof ObjectAction) {
            return new ProxyObjectAction((ObjectAction)action, data);
        }
        if (action instanceof FileAction && data instanceof File) {
            return new ProxyFileAction((FileAction)action, (File)data);
        }
        if (action instanceof FileAction && data instanceof PersistentObject && ParserFactory.getCache().isCached((PersistentObject)data)) {
            return new ProxyFileAction((FileAction)action, ParserFactory.getCache().getSourceFile(data));
        }
        if (action instanceof FilesAction && data instanceof File[]) {
            return new ProxyFileAction((FileAction)((FilesAction)action), (File[])data);
        }
        if (action instanceof ExtAction && data instanceof File) {
            ExtAction real = (ExtAction)action.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            real.setPath((File)data);
            return real;
        }
        if (action instanceof ExtAction && data instanceof PersistentObject) {
            ExtAction real = (ExtAction)action.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            real.setPath(ParserFactory.getCache().getSourceFile(data));
            return real;
        }
        if (action instanceof XAction) {
            return (XAction)action.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new Exception("Unknown action type: " + String.valueOf(action) + " and object combo: " + String.valueOf(data));
    }

    static {
        GMT_ACTIONS = GMX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetMatrixViewerAction(), null, new GeneSetMatrix2GeneSetsAction(), new GeneSetMatrix2GeneSetAction()});
        RPT_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ReportViewerAction()});
    }
}

