/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassVector {
    Map<Integer, List<Integer>> classNumber2IndicesMap = new HashMap<Integer, List<Integer>>();
    int[] assignments;
    Map<Integer, String> classNumber2LabelMap = new HashMap<Integer, String>();
    int classCount;

    public ClassVector(String[] x, String[] classes) {
        int i;
        this.assignments = new int[x.length];
        int maxClassNumber = classes.length;
        HashMap<String, Integer> className2ClassNumberMap = new HashMap<String, Integer>();
        for (i = 0; i < classes.length; ++i) {
            className2ClassNumberMap.put(classes[i], i);
            this.classNumber2IndicesMap.put(i, new ArrayList());
            this.classNumber2LabelMap.put(i, classes[i]);
        }
        for (i = 0; i < x.length; ++i) {
            Integer classNumberInteger = (Integer)className2ClassNumberMap.get(x[i]);
            if (classNumberInteger == null) {
                classNumberInteger = maxClassNumber++;
                className2ClassNumberMap.put(x[i], classNumberInteger);
                this.classNumber2IndicesMap.put(classNumberInteger, new ArrayList());
                this.classNumber2LabelMap.put(classNumberInteger, x[i]);
            }
            this.assignments[i] = classNumberInteger;
            List<Integer> indices = this.classNumber2IndicesMap.get(classNumberInteger);
            indices.add(i);
        }
        this.classCount = maxClassNumber;
    }

    public int size() {
        return this.assignments.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.assignments.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.getClassName(this.assignments[i]));
        }
        return sb.toString();
    }

    public int getClassCount() {
        return this.classCount;
    }

    public String getClassName(int classNumber) {
        return this.classNumber2LabelMap.get(classNumber);
    }

    public int getAssignment(int index) {
        return this.assignments[index];
    }
}

