/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.parsers.PobBoxModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class PobBoxModels
implements ComboBoxModel {
    private PobBoxModel[] fModels;
    private Logger log = LoggerFactory.getLogger(PobBoxModels.class);
    private ModelItsIndex fSelModelIndex;

    public PobBoxModels(PobBoxModel[] models) {
        this.fModels = models;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        for (int i = 0; i < this.fModels.length; ++i) {
            this.fModels[i].addListDataListener(l);
        }
    }

    @Override
    public Object getElementAt(int index) {
        ModelItsIndex mii = this.getModelAtElementIndex(index);
        if (mii == null) {
            return null;
        }
        return mii.getElement();
    }

    private ModelItsIndex getModelAtElementIndex(int index) {
        int cnt = 0;
        for (int i = 0; i < this.fModels.length; ++i) {
            for (int t = 0; t < this.fModels[i].getSize(); ++t) {
                if (cnt == index) {
                    return new ModelItsIndex(this.fModels[i].getElementAt(t), this.fModels[i], t, index);
                }
                ++cnt;
            }
        }
        this.log.error(MarkerFactory.getMarker((String)"FATAL"), "No model found for index: {}", (Object)index);
        return null;
    }

    private ModelItsIndex getModelForObject(Object obj) {
        int cnt = 0;
        for (int i = 0; i < this.fModels.length; ++i) {
            for (int t = 0; t < this.fModels[i].getSize(); ++t) {
                if (this.fModels[i].getElementAt(t) == obj) {
                    return new ModelItsIndex(obj, this.fModels[i], t, cnt);
                }
                ++cnt;
            }
        }
        if (this.log.isErrorEnabled()) {
            StringBuffer buf = new StringBuffer("No model found for object: " + String.valueOf(obj)).append('\n');
            buf.append("# of models: " + this.fModels.length).append('\n');
            for (int i = 0; i < this.fModels.length; ++i) {
                buf.append(this.fModels[i].getElementAt(0)).append('\n');
            }
            this.log.error(MarkerFactory.getMarker((String)"FATAL"), buf.toString());
        }
        return null;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int i = 0; i < this.fModels.length; ++i) {
            size += this.fModels[i].getSize();
        }
        return size;
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        for (int i = 0; i < this.fModels.length; ++i) {
            this.fModels[i].removeListDataListener(l);
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.fSelModelIndex == null) {
            return null;
        }
        return this.fSelModelIndex.element;
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.fSelModelIndex = this.getModelForObject(obj);
    }

    class ModelItsIndex {
        DefaultComboBoxModel model;
        int itsElementIndex;
        int globalModelIndex;
        Object element;

        ModelItsIndex(Object element, DefaultComboBoxModel model, int elementIndex, int globalModelIndex) {
            this.element = element;
            this.model = model;
            this.itsElementIndex = elementIndex;
            this.globalModelIndex = globalModelIndex;
        }

        Object getElement() {
            return this.model.getElementAt(this.itsElementIndex);
        }
    }
}

