/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.fdr;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.SkewCorrectedFdrStruc;
import gnu.trove.THashMap;

public class FdrAlgs {
    public static FdrMap calcFdrs_skewed(LabelledVector real_scores, Dataset rnd_scores_by_row_FULL, LabelledVector real_scores_norm, DatasetModed all_rnd_scores_norm_moded_pos, DatasetModed all_rnd_scores_norm_moded_neg, SortMode sort) {
        FdrMap map = new FdrMap();
        FdrAlgs._calcFdrs_skewed(real_scores, rnd_scores_by_row_FULL, real_scores_norm, all_rnd_scores_norm_moded_pos, all_rnd_scores_norm_moded_neg, sort, Order.DESCENDING, true, map);
        FdrAlgs._calcFdrs_skewed(real_scores, rnd_scores_by_row_FULL, real_scores_norm, all_rnd_scores_norm_moded_pos, all_rnd_scores_norm_moded_neg, sort, Order.ASCENDING, false, map);
        return map;
    }

    private static void _calcFdrs_skewed(LabelledVector real_scores, Dataset rnd_scores_by_row_FULL, LabelledVector real_scores_norm, DatasetModed all_rnd_scores_norm_moded_pos, DatasetModed all_rnd_scores_norm_moded_neg, SortMode sort, Order order, boolean doPos, FdrMap map) {
        if (real_scores == null) {
            throw new IllegalArgumentException("Param real_scores cannot be null");
        }
        if (rnd_scores_by_row_FULL == null) {
            throw new IllegalArgumentException("Param rnd_scores_by_row_FULL cannot be null");
        }
        if (real_scores.getSize() != real_scores_norm.getSize()) {
            throw new MismatchedSizeException("real_scores", real_scores.getSize(), "real_scores_norm", real_scores_norm.getSize());
        }
        RankedList real_scores_norm_sorted = real_scores_norm.sort(sort, order);
        for (int r = 0; r < real_scores.getSize(); ++r) {
            SkewCorrectedFdrStruc fdr;
            String name = real_scores.getLabel(r);
            float real_score_of_name = real_scores.getScore(r);
            if (doPos && XMath.isPositive(real_score_of_name)) {
                fdr = new SkewCorrectedFdrStruc(name, real_score_of_name, real_scores_norm_sorted, rnd_scores_by_row_FULL.getRow(name), all_rnd_scores_norm_moded_pos, all_rnd_scores_norm_moded_neg, doPos);
                map.add(name, fdr);
                continue;
            }
            if (doPos || !XMath.isNegative(real_score_of_name)) continue;
            fdr = new SkewCorrectedFdrStruc(name, real_score_of_name, real_scores_norm_sorted, rnd_scores_by_row_FULL.getRow(name), all_rnd_scores_norm_moded_pos, all_rnd_scores_norm_moded_neg, doPos);
            map.add(name, fdr);
        }
    }

    public static class FdrMap
    extends THashMap {
        FdrMap() {
        }

        public SkewCorrectedFdrStruc getFdr(String name) {
            Object obj = this.get(name);
            if (obj == null) {
                throw new IllegalArgumentException("No fdr data for: " + name);
            }
            return (SkewCorrectedFdrStruc)obj;
        }

        private void add(String name, SkewCorrectedFdrStruc fdr) {
            if (this.containsKey(name)) {
                throw new IllegalArgumentException("Already have fdr entry for: " + String.valueOf(fdr));
            }
            this.put(name, fdr);
        }
    }
}

