/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.heatmap;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.xbench.heatmap.DisplayState;
import edu.mit.broad.xbench.heatmap.GramImager;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.image.DisplaySettings;
import org.genepattern.heatmap.image.HeatMap;

public class GramImagerImpl
implements GramImager {
    private DisplayState fDisplayState;

    public GramImagerImpl() {
        this(null);
    }

    public GramImagerImpl(DisplayState state) {
        this.fDisplayState = state == null ? new DisplayState() : state;
    }

    @Override
    public HeatMap createBpogHeatMap(Dataset ds) {
        return this._xcoreCreateBpogImage(ds, null);
    }

    @Override
    public HeatMap createBpogHeatMap(Dataset ds, Template t) {
        return this._xcoreCreateBpogImage(ds, t);
    }

    private DisplaySettings _createDefaultDisplaySettings(Dataset origDs) {
        DisplaySettings set = new DisplaySettings();
        set.drawGrid = true;
        set.rowSize = 12;
        set.columnSize = 12;
        set.sampleAnnonationsHeight = 15;
        set.drawGrid = true;
        set.showFeatureGridLines = true;
        set.showSampleGridLines = true;
        set.drawRowDescriptions = origDs.getAnnot().getFeatureAnnot().hasNativeDescriptions();
        set.drawRowNames = true;
        if (this.fDisplayState != null && this.fDisplayState.getColorScheme() != null) {
            set.colorConverter = this.fDisplayState.getColorScheme();
        }
        return set;
    }

    private HeatMap _xcoreCreateBpogImage(Dataset origDs, Template origT_opt) {
        if (origDs == null) {
            throw new IllegalArgumentException("Param origDs cannot be null");
        }
        DisplaySettings displaySettings_opt = this._createDefaultDisplaySettings(origDs);
        IExpressionData data = GPWrappers.createIExpressionData(origDs);
        return HeatMap.createHeatMap(data, displaySettings_opt, GPWrappers.createFeatureAnnotator(origDs), GPWrappers.createSampleAnnotator(origDs, origT_opt));
    }
}

