/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.DataType;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.parsers.ChipParser;
import edu.mit.broad.genome.parsers.ClsParser;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.parsers.GeneSetParser;
import edu.mit.broad.genome.parsers.GmtParser;
import edu.mit.broad.genome.parsers.GmxParser;
import edu.mit.broad.genome.parsers.PclParser;
import edu.mit.broad.genome.parsers.RankedListParser;
import edu.mit.broad.genome.parsers.ReportParser;
import edu.mit.broad.genome.parsers.ResParser;
import edu.mit.broad.genome.parsers.TxtDatasetParser;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormat
extends DataType
implements Constants {
    private static final Logger klog = LoggerFactory.getLogger(DataFormat.class);
    public static final DataFormat XLS_FORMAT = new DataFormat(ExtFormat.class, "Excel", "Microsoft Excel", "xls", JarResources.getIcon("Xls.gif"), null);
    public static final DataFormat TXT_FORMAT = new DataFormat(ExtFormat.class, "Text", "Plain Text", "txt", JarResources.getIcon("Txt.gif"), null);
    public static final DataFormat XML_FORMAT = new DataFormat(ExtFormat.class, "XML", "Extensible Markup Language", "xml", JarResources.getIcon("Xml.gif"), null);
    public static final DataFormat TSV_FORMAT = new DataFormat(ExtFormat.class, "TSV", "Tab-separated values", "tsv", JarResources.getIcon("Xls.gif"), null);
    public static final DataFormat RES_FORMAT = new DataFormat(Dataset.class, "Dataset", "MIT Format for a Dataset with P-Calls", "res", JarResources.getIcon("Res16.gif"), ResParser.class);
    public static final DataFormat GCT_FORMAT = new DataFormat(Dataset.class, "Dataset", "MIT Format for a Dataset", "gct", JarResources.getIcon("Gct16.gif"), GctParser.class);
    public static final DataFormat TXT_DATASET_FORMAT = new DataFormat(Dataset.class, "Dataset", "generic Txt Format for Datasets", "txt", JarResources.getIcon("Txt.gif"), TxtDatasetParser.class);
    public static final DataFormat PCL_FORMAT = new DataFormat(Dataset.class, "Dataset", "Stanford Format for a Dataset", "pcl", JarResources.getIcon("Pcl.gif"), PclParser.class);
    public static final DataFormat CLS_FORMAT = new DataFormat(Template.class, "Template", "MIT Format for Class Labels", "cls", JarResources.getIcon("Cls.gif"), ClsParser.class);
    public static final DataFormat GRP_FORMAT = new DataFormat(GeneSet.class, "GeneSet", "MIT GeneSet Format", "grp", JarResources.getIcon("Grp.gif"), GeneSetParser.class);
    public static final DataFormat RNK_FORMAT = new DataFormat(RankedList.class, "RankedList", "MIT RankedList Format", "rnk", JarResources.getIcon("Rnk.png"), RankedListParser.class);
    public static final DataFormat GMX_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix", "MIT format for a Matrix of Gene Sets", "gmx", JarResources.getIcon("Gmx.png"), GmxParser.class);
    public static final DataFormat GMT_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix_Transposed", "MIT format for a Matrix of Gene Sets", "gmt", JarResources.getIcon("Gmt.png"), GmtParser.class);
    public static final DataFormat EDB_FORMAT = new DataFormat(EnrichmentDb.class, "Enrichment-Database", "MIT format for an enrichment database", "edb", JarResources.getIcon("Edb.png"), EdbFolderParser.class);
    public static final DataFormat RPT_FORMAT = new DataFormat(Report.class, "Report", "Report for a program", "rpt", JarResources.getIcon("Rpt.gif"), ReportParser.class);
    public static final DataFormat CHIP_FORMAT = new DataFormat(Chip.class, "Chip", "Chip", "chip", JarResources.getIcon("Chip16.png"), ChipParser.class);
    private static final DataFormat[] ALL = new DataFormat[]{RES_FORMAT, GCT_FORMAT, TXT_DATASET_FORMAT, PCL_FORMAT, CLS_FORMAT, GRP_FORMAT, GMT_FORMAT, GMX_FORMAT, RNK_FORMAT, RPT_FORMAT, EDB_FORMAT, CHIP_FORMAT, XLS_FORMAT, TXT_FORMAT, XML_FORMAT, TSV_FORMAT};
    public static final DataFormat[] ALL_DATASET_FORMATS = new DataFormat[]{GCT_FORMAT, RES_FORMAT, TXT_DATASET_FORMAT, PCL_FORMAT};
    public static final DataFormat[] ALL_GENESETMATRIX_FORMATS = new DataFormat[]{GMX_FORMAT, GMT_FORMAT};
    private static final Map<Class, String> kClassExtMap = new HashMap<Class, String>();
    private static final Map<String, DataFormat> kExtDfMap = new HashMap<String, DataFormat>();
    private static final Map<Class, Icon> kClassIconMap = new HashMap<Class, Icon>();
    private static final Map<Class, String> kClassNameMap = new HashMap<Class, String>();
    private String fName;
    private String fDesc;
    private Icon fIcon;
    private String fExt;
    private Class fParserClass;
    private FilenameFilter fFilt;

    public DataFormat() {
    }

    public static FileView getParsableFileView() {
        return new ParsableFileView();
    }

    public DataFormat(Class repClass, String name, String desc, String ext, Icon icon, Class parserClass) throws IllegalArgumentException {
        super(repClass, ext);
        if (name == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("Param desc cannot be null");
        }
        if (!SystemUtils.isHeadless() && icon == null) {
            throw new IllegalArgumentException("Param icon cannot be null");
        }
        if (ext == null) {
            throw new IllegalArgumentException("Null extension is not allowed: " + ext);
        }
        if (ext.startsWith(".")) {
            throw new IllegalArgumentException("DataFormat extension cannot begin with a period '.' " + ext);
        }
        if (ext.length() <= 0) {
            throw new IllegalArgumentException("DataFormat extension cannot have zero length " + ext);
        }
        this.fExt = ext;
        this.fIcon = icon;
        this.fName = name;
        this.fDesc = desc;
        this.fParserClass = parserClass;
    }

    public String getName() {
        return this.fName;
    }

    public String getDesc() {
        return this.fDesc;
    }

    public FilenameFilter getFilenameFilter() {
        if (this.fFilt == null) {
            this.fFilt = DataFormat.createFnf(this.fExt);
        }
        return this.fFilt;
    }

    private static FilenameFilter createFnf(final String ext) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(ext);
            }
        };
    }

    public String getExtension() {
        return this.fExt;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    @Override
    public String toString() {
        return this.getName() + "[" + this.getExtension() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DataFormat) {
            return ((DataFormat)obj).fExt.equals(this.fExt);
        }
        return this.fExt.equalsIgnoreCase(obj.toString());
    }

    public static DataFormat getExtension(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        String ext = obj instanceof DataFormat ? ((DataFormat)obj).getExtension() : obj.toString();
        for (int i = 0; i < ALL.length; ++i) {
            if (ALL[i].getExtension().equalsIgnoreCase(ext)) {
                return ALL[i];
            }
            if (!ALL[i].toString().equalsIgnoreCase(ext)) continue;
            return ALL[i];
        }
        throw new IllegalArgumentException("No DataFormat found for: " + ext);
    }

    public static String getExtension(Class clz) {
        Class cl = DataFormat._deconvClass(clz);
        String obj = kClassExtMap.get(cl);
        if (obj != null) {
            return obj.toString();
        }
        klog.warn("No extension found for class: {}", (Object)cl);
        return "txt";
    }

    public static String getExtension(PersistentObject pob) {
        if (pob == null) {
            return null;
        }
        return DataFormat.getExtension(pob.getClass());
    }

    public static DataFormat getDataFormat(String ext) {
        DataFormat obj = kExtDfMap.get(ext);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public static Icon getIcon(String ext) {
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getIcon();
        }
        return JarResources.ICON_UNKNOWN_DATA_FORMAT;
    }

    public static Icon getIconOrNull(String ext) {
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getIcon();
        }
        return null;
    }

    public static String getDesc(File file) {
        String ext = NamingConventions.getExtension(file).toLowerCase();
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getDesc();
        }
        return null;
    }

    private static Class _deconvClass(Class pobClass) {
        if (kClassNameMap.containsKey(pobClass)) {
            return pobClass;
        }
        Class<?>[] interfaces = pobClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String obj = kClassNameMap.get(interfaces[i]);
            if (obj == null) continue;
            return interfaces[i];
        }
        if (pobClass.equals(DefaultGeneSetMatrix.class)) {
            return GeneSetMatrix.class;
        }
        if (pobClass.equals(TemplateImpl.class)) {
            return Template.class;
        }
        return pobClass;
    }

    public static Icon getIcon(Object obj) {
        if (obj == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        if (obj instanceof File) {
            return DataFormat.getIcon(NamingConventions.getExtension((File)obj));
        }
        if (obj instanceof String) {
            return DataFormat.getIcon(NamingConventions.getExtension(obj.toString()));
        }
        Icon ic = kClassIconMap.get(obj.getClass());
        if (ic == null && obj instanceof PersistentObject) {
            Class repcl = DataFormat.getRepresentationClass((PersistentObject)obj);
            ic = kClassIconMap.get(repcl);
        }
        if (ic == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        return ic;
    }

    public static Class getRepresentationClass(PersistentObject pob) {
        if (pob instanceof Template) {
            return Template.class;
        }
        if (pob instanceof FeatureAnnot) {
            return FeatureAnnot.class;
        }
        if (pob instanceof GeneSet) {
            return GeneSet.class;
        }
        if (pob instanceof RankedList) {
            return RankedList.class;
        }
        if (pob instanceof Dataframe) {
            return Dataframe.class;
        }
        if (pob instanceof Matrix) {
            return Matrix.class;
        }
        if (pob instanceof GeneSetMatrix) {
            return GeneSetMatrix.class;
        }
        if (pob instanceof StringDataframe) {
            return StringDataframe.class;
        }
        if (pob instanceof Report) {
            return Report.class;
        }
        if (pob instanceof EnrichmentDb) {
            return EnrichmentDb.class;
        }
        if (pob instanceof Chip) {
            return Chip.class;
        }
        if (pob instanceof Dataset) {
            return Dataset.class;
        }
        if (pob instanceof SampleAnnot) {
            return SampleAnnot.class;
        }
        throw new IllegalArgumentException("Unknown object: " + String.valueOf(pob));
    }

    public static Icon getIcon(File file) {
        String ext = NamingConventions.getExtension(file);
        return DataFormat.getIcon(ext);
    }

    public static Icon getIconOrNull(File file) {
        String ext = NamingConventions.getExtension(file).toLowerCase();
        return DataFormat.getIconOrNull(ext);
    }

    public static boolean isCompatibleRepresentationClass(Object obj, Class[] classes) {
        for (int c = 0; c < classes.length; ++c) {
            if (!DataFormat.isCompatibleRepresentationClass(obj, classes[c])) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleRepresentationClass(Object obj, Class cl) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Parameter cl cannot be null");
        }
        if (obj.getClass().getName().equals(cl.getName())) {
            return true;
        }
        Class<?>[] interfacesA = obj.getClass().getInterfaces();
        for (int i = 0; i < interfacesA.length; ++i) {
            if (!cl.getName().equals(interfacesA[i].getName())) continue;
            return true;
        }
        Class<?>[] interfacesB = cl.getInterfaces();
        for (int i = 0; i < interfacesB.length; ++i) {
            if (!obj.getClass().getName().equals(interfacesB[i].getName())) continue;
            return true;
        }
        for (int a = 0; a < interfacesA.length; ++a) {
            for (int b = 0; b < interfacesB.length; ++b) {
                if (!interfacesA[a].getName().equals(interfacesB[b].getName())) continue;
                return true;
            }
        }
        if (obj instanceof GeneSetMatrix) {
            return true;
        }
        return obj instanceof Dataset;
    }

    static {
        for (int i = 0; i < ALL.length; ++i) {
            kExtDfMap.put(ALL[i].getExtension(), ALL[i]);
            Class<?> repClass = ALL[i].getRepresentationClass();
            if (ExtFormat.class.isAssignableFrom(repClass)) continue;
            if (!kClassNameMap.containsKey(repClass)) {
                kClassNameMap.put(repClass, ALL[i].getName());
            }
            if (!kClassExtMap.containsKey(repClass)) {
                kClassExtMap.put(repClass, ALL[i].getExtension());
            }
            if (kClassIconMap.containsKey(repClass)) continue;
            kClassIconMap.put(repClass, ALL[i].getIcon());
        }
    }

    static class ParsableFileView
    extends FileView {
        ParsableFileView() {
        }

        @Override
        public Icon getIcon(File file) {
            return DataFormat.getIconOrNull(file);
        }

        @Override
        public String getTypeDescription(File file) {
            return null;
        }

        @Override
        public String getDescription(File file) {
            return DataFormat.getDesc(file);
        }
    }

    private class ExtFormat {
        private ExtFormat() {
        }
    }
}

