/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class GseaPreferencesDialog
extends JDialog {
    public GseaPreferencesDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.setModal(true);
        BorderLayout borderLayout = new BorderLayout(15, 15);
        this.setLayout(borderLayout);
        OptionsPanel panel = new OptionsPanel();
        this.add((Component)panel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout(15, 15));
        JButton helpButton = JarResources.createHelpButton("#Prefs-Window");
        helpButton.setMargin(new Insets(0, 30, 0, 30));
        JPanel helpPanel = new JPanel(new FlowLayout());
        helpPanel.add(helpButton);
        buttonPanel.add((Component)helpPanel, "West");
        AbstractAction okAction = new AbstractAction(UIManager.getString("OptionPane.okButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GseaPreferencesDialog.this.savePreferences();
                GseaPreferencesDialog.this.setVisible(false);
                Application.getWindowManager().showMessage("Saved preferences (many preferences need a restart of GSEA)");
                GseaPreferencesDialog.this.dispose();
            }
        };
        JButton okButton = new JButton("  OK  ");
        okButton.setAction(okAction);
        okButton.setMargin(new Insets(0, 30, 0, 30));
        AbstractAction cancelAction = new AbstractAction(UIManager.getString("OptionPane.cancelButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GseaPreferencesDialog.this.setVisible(false);
                GseaPreferencesDialog.this.dispose();
            }
        };
        JPanel okCancelPanel = new JPanel(new FlowLayout());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setAction(cancelAction);
        cancelButton.setMargin(new Insets(0, 30, 0, 30));
        okCancelPanel.add(cancelButton);
        okCancelPanel.add(okButton);
        buttonPanel.add((Component)okCancelPanel, "East");
        return buttonPanel;
    }

    private void savePreferences() {
        try {
            XPreferencesFactory.kAskBeforeAppShutdown.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kOnlineMode.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kCytoscapeRESTPort.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kDefaultReportsOutputDir.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kMakeGseaUpdateCheck.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kBiasedVar.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kMedian.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kFixLowVar.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.save();
        }
        catch (Exception e) {
            Application.getWindowManager().showError("Trouble saving preferences", e);
        }
    }

    private static StringBuffer _createRowStr(int num) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 5dlu,");
        for (int i = 0; i < num; ++i) {
            rowStr.append("pref, 3dlu");
            if (num == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    private static CompoundBorder createRoundCornerBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), title), BorderFactory.createEmptyBorder(0, 6, 4, 6)));
    }

    static class OptionsPanel
    extends JPanel {
        public OptionsPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createPanel(), "Center");
        }

        private JPanel createPathsPanel() {
            String str = "275dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("275dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Cytoscape REST port (for Enrichment Map Visualization)"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kCytoscapeRESTPort.getSelectionComponent().getComponent(), cc.xy(1, rowCnt += 2));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Program settings "));
            return panel;
        }

        private JPanel createOutputPanel() {
            String str = "75dlu,      4dlu,        200dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(1);
            FormLayout layout = new FormLayout("75dlu,      4dlu,        200dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Default output folder"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kDefaultReportsOutputDir.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Report settings "));
            return panel;
        }

        private JPanel createAppPreferencesPanel() {
            String str = "180dlu,      4dlu,        10dlu";
            int rowCnt = 5;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("180dlu,      4dlu,        10dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Prompt before closing application"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kAskBeforeAppShutdown.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel("Connect over the Internet"), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kOnlineMode.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel("Check for new GSEA version on startup"), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kMakeGseaUpdateCheck.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Application preferences "));
            return panel;
        }

        private JPanel createAlgPanel() {
            String str = "200dlu,      4dlu,        50dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("200dlu,      4dlu,        50dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel(XPreferencesFactory.kMedian.getName()), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kMedian.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel(XPreferencesFactory.kFixLowVar.getName()), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kFixLowVar.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel(XPreferencesFactory.kBiasedVar.getName()), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kBiasedVar.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder("Algorithm: These are 'Defaults' "));
            return panel;
        }

        private JPanel createPanel() {
            JPanel outPanel = this.createOutputPanel();
            JPanel pathsPanel = this.createPathsPanel();
            JPanel algPanel = this.createAlgPanel();
            JPanel windowsAndTabsPanel = this.createAppPreferencesPanel();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(Box.createVerticalStrut(20));
            panel.add(outPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(pathsPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(Box.createVerticalStrut(6));
            panel.add(windowsAndTabsPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(Box.createVerticalStrut(6));
            panel.add(algPanel);
            panel.add(Box.createVerticalStrut(30));
            return panel;
        }
    }
}

