/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.exporter;

import java.io.IOException;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.export.exporter.AbstractMatrixWriterExporter;
import org.ujmp.core.export.format.MatrixDenseCSVExportFormat;
import org.ujmp.core.util.StringUtil;

public class DefaultMatrixWriterCSVExporter
extends AbstractMatrixWriterExporter
implements MatrixDenseCSVExportFormat {
    public DefaultMatrixWriterCSVExporter(Matrix matrix, Writer writer) {
        super(matrix, writer);
    }

    public void asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        Writer writer = this.getWriter();
        Matrix matrix = this.getMatrix();
        long rowCount = matrix.getRowCount();
        long colCount = matrix.getColumnCount();
        int row = 0;
        while ((long)row < rowCount) {
            int col = 0;
            while ((long)col < colCount) {
                String s;
                if (enclosingCharacter != '\u0000') {
                    writer.append(enclosingCharacter);
                }
                if ((s = StringUtil.convert(matrix.getAsObject(row, col))) == null) {
                    s = "";
                }
                if (s.contains("\n") || s.contains("\r") || s.contains("\\u000a") || s.contains("\\u000d")) {
                    throw new RuntimeException("at least one cell contains a line break, CSV output will be garbage");
                }
                if (s.contains("\t") || s.contains("\\u0009") || s.contains("\\u00ad")) {
                    throw new RuntimeException("at least one cell contains a tabulator, CSV output will be garbage");
                }
                writer.append(s);
                if (enclosingCharacter != '\u0000') {
                    writer.append(enclosingCharacter);
                }
                if ((long)col < colCount - 1L) {
                    writer.append(columnSeparator);
                }
                ++col;
            }
            if ((long)row < rowCount - 1L) {
                writer.append(lineSeparator);
            }
            ++row;
        }
        writer.flush();
    }

    public void asDenseCSV(char columnSeparator) throws IOException {
        this.asDenseCSV(columnSeparator, '\u0000');
    }

    public void asDenseCSV() throws IOException {
        this.asDenseCSV('\t');
    }
}

