/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.models.NumberedProxyModel;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.core.Widget;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewer
extends JPanel
implements Widget {
    protected Logger log;
    private Icon fIcon;
    private String fName;
    private String fTitle;

    protected AbstractViewer() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public AbstractViewer(String name, Icon icon, String title) {
        this.init(name, icon, title);
    }

    public AbstractViewer(String name, Icon icon, PersistentObject pob_for_setting_title) {
        this(name, icon, AbstractViewer.formatTitle(pob_for_setting_title, name));
    }

    protected void init(String name, Icon icon, String title) {
        if (name == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Param title cannot be null");
        }
        this.fIcon = icon;
        this.fName = name;
        this.fTitle = title;
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(this.getClass());
        }
    }

    @Override
    public JComponent getWrappedComponent() {
        this._checkInit();
        return this;
    }

    @Override
    public Icon getAssociatedIcon() {
        this._checkInit();
        return this.fIcon;
    }

    @Override
    public String getName() {
        this._checkInit();
        return this.fName;
    }

    private void _checkInit() {
        if (this.fName == null) {
            throw new IllegalStateException("Viewer likely not init'ed name: " + this.fName);
        }
        if (this.fTitle == null) {
            throw new IllegalStateException("Viewer likely not init'ed title: " + this.fTitle);
        }
    }

    @Override
    public String getAssociatedTitle() {
        return this.fTitle;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    protected static String formatTitle(PersistentObject pob, String name) {
        if (pob == null) {
            return "na -- " + name;
        }
        return pob.getName();
    }

    protected static void setColumnSize(int size, int col, JTable table, boolean alsoMax) {
        GuiHelper.Table.setColumnSize(size, col, table, alsoMax);
    }

    protected static JScrollPane createAlwaysScrollPane(JTable table) {
        JScrollPane sp = new JScrollPane(table);
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        return sp;
    }

    protected static SortableTable createTable(TableModel model, boolean addRowNumCol, boolean boldHeaders) {
        TableModel amodel = model;
        if (addRowNumCol) {
            amodel = new NumberedProxyModel(model);
        }
        SortableTable table = new SortableTable(amodel);
        if (addRowNumCol) {
            AbstractViewer.setColumnSize(35, 0, (JTable)table, true);
        }
        table.setCellSelectionEnabled(true);
        return table;
    }
}

