/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.util.TimerTask;
import org.ujmp.core.Coordinates;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.core.util.matrices.ThreadMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningThreadsMatrix
extends DefaultMapMatrix<Object, Object> {
    private static final long serialVersionUID = -6988423129848472319L;
    private final UJMPTimer timer;

    public RunningThreadsMatrix() {
        super(ThreadMap.getInstance());
        this.setLabel("Running Threads");
        this.setColumnLabel(0L, "Thread");
        this.setColumnLabel(1L, "StackTrace");
        final RunningThreadsMatrix m = this;
        TimerTask task = new TimerTask(){
            private MapMatrix<Object, Object> oldMap = new DefaultMapMatrix<Object, Object>();

            public void run() {
                if (this.oldMap.size() != RunningThreadsMatrix.this.size()) {
                    this.oldMap.clear();
                    this.oldMap.putAll(m);
                    m.fireValueChanged();
                } else {
                    for (Object key : this.oldMap.keySet()) {
                        if (!this.oldMap.containsKey(key)) {
                            this.oldMap.clear();
                            this.oldMap.putAll(m);
                            m.fireValueChanged();
                            break;
                        }
                        Object value = m.get(key);
                        if (value == this.oldMap.get(key)) continue;
                        this.oldMap.put(key, value);
                        m.fireValueChanged(Coordinates.wrap(m.indexOfKey(key), 1L), value);
                    }
                }
            }
        };
        this.timer = UJMPTimer.newInstance(this.getClass().getSimpleName());
        this.timer.schedule(task, 1000L, 1000L);
    }
}

