/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class SOTACell {
    public FloatMatrix dataMatrix;
    public SOTACell parent;
    public SOTACell left;
    public SOTACell right;
    public SOTACell pred;
    public SOTACell succ;
    public FloatMatrix centroidGene;
    public Vector members;
    public double cellDiversity;
    public double cellVariance;
    private int numberOfSamples;
    public boolean changedMembership;

    public SOTACell(int n, FloatMatrix floatMatrix) {
        this.dataMatrix = floatMatrix;
        this.numberOfSamples = n;
        this.changedMembership = false;
        this.centroidGene = new FloatMatrix(1, this.numberOfSamples);
        for (int i = 0; i < this.numberOfSamples; ++i) {
            this.centroidGene.set(0, i, 0.0f);
        }
        this.members = new Vector();
        this.cellDiversity = 0.0;
        this.cellVariance = 0.0;
        this.succ = null;
        this.pred = null;
        this.right = null;
        this.left = null;
        this.parent = null;
    }

    public void removeMember(int n) {
        for (int i = 0; i < this.members.size(); ++i) {
            if (n != (Integer)this.members.elementAt(i)) continue;
            this.members.removeElementAt(i);
            this.changedMembership = true;
            break;
        }
    }

    public void migrateCentroid(int n, float f) {
        for (int i = 0; i < this.numberOfSamples; ++i) {
            if (Float.isNaN(this.dataMatrix.get(n, i))) continue;
            this.centroidGene.set(0, i, this.centroidGene.get(0, i) + f * (this.dataMatrix.get(n, i) - this.centroidGene.get(0, i)));
        }
    }

    public float getColumnVar(int n) {
        int n2 = this.members.size();
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = (Integer)this.members.elementAt(i);
            float f2 = this.dataMatrix.get(n4, n);
            if (Float.isNaN(f2)) continue;
            f = (float)((double)f + Math.pow(f2 - this.centroidGene.get(0, n), 2.0));
            ++n3;
        }
        if (n3 > 1) {
            return (float)Math.sqrt(f / (float)(n3 - 1));
        }
        return 0.0f;
    }

    public void addMember(int n) {
        this.members.add(new Integer(n));
        this.changedMembership = true;
    }

    public SOTACell findSister() {
        if (this != null) {
            if (this.parent.left == this) {
                return this.parent.right;
            }
            return this.parent.left;
        }
        return null;
    }
}

