/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.util.FloatMatrix;

public class ExperimentUtil {
    public static float distance(FloatMatrix floatMatrix, int n, int n2, int n3, float f, boolean bl) {
        float f2 = Float.NaN;
        switch (n3) {
            case 1: {
                f2 = ExperimentUtil.pearson(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 2: {
                f2 = ExperimentUtil.cosine(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 3: {
                f2 = ExperimentUtil.covariance(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 4: {
                f2 = ExperimentUtil.euclidian(floatMatrix, n, n2, f);
                break;
            }
            case 5: {
                f2 = ExperimentUtil.dotProduct(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 6: {
                f2 = ExperimentUtil.pearsonUncentered(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 7: {
                f2 = (float)Math.pow(ExperimentUtil.pearsonUncentered(floatMatrix, n, n2, f), 2.0);
                f *= -1.0f;
                break;
            }
            case 8: {
                f2 = ExperimentUtil.manhattan(floatMatrix, n, n2, f);
                break;
            }
            case 9: {
                f2 = ExperimentUtil.spearmanRank(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 10: {
                f2 = ExperimentUtil.kendallsTau(floatMatrix, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 11: {
                f2 = ExperimentUtil.mutualInformation(floatMatrix, n, n2, f);
                break;
            }
        }
        if (bl) {
            f2 = Math.abs(f2);
        }
        return f2 * f;
    }

    public static float geneDistance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, int n3, float f, boolean bl) {
        float f2 = Float.NaN;
        switch (n3) {
            case 1: {
                f2 = ExperimentUtil.genePearson(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 2: {
                f2 = ExperimentUtil.geneCosine(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 3: {
                f2 = ExperimentUtil.geneCovariance(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 4: {
                f2 = ExperimentUtil.geneEuclidianDistance(floatMatrix, floatMatrix2, n, n2, f);
                break;
            }
            case 5: {
                f2 = ExperimentUtil.geneDotProduct(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 6: {
                f2 = ExperimentUtil.genePearsonUncentered(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 7: {
                f2 = (float)Math.pow(ExperimentUtil.genePearsonUncentered(floatMatrix, floatMatrix2, n, n2, f), 2.0) * f;
                f *= -1.0f;
                break;
            }
            case 8: {
                f2 = ExperimentUtil.geneManhattan(floatMatrix, floatMatrix2, n, n2, f);
                break;
            }
            case 9: {
                f2 = ExperimentUtil.geneSpearmanRank(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 10: {
                f2 = ExperimentUtil.geneKendallsTau(floatMatrix, floatMatrix2, n, n2, f);
                f *= -1.0f;
                break;
            }
            case 11: {
                f2 = ExperimentUtil.geneMutualInformation(floatMatrix, floatMatrix2, n, n2, f);
                break;
            }
        }
        if (bl) {
            f2 = Math.abs(f2);
        }
        return f2 * f;
    }

    public static float genePearsonOld(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f2 = Float.MIN_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d4 += (double)floatMatrix.get(n, n3);
            d5 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d4 /= (double)n5;
        d5 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d6 = (double)floatMatrix.get(n, n3) - d4;
            double d7 = (double)floatMatrix2.get(n2, n3) - d5;
            d += d6 * d6;
            d2 += d7 * d7;
            d3 += d6 * d7;
        }
        return (float)(d3 / (Math.sqrt(d * d2) + (double)f2) * (double)f);
    }

    public static float genePearson(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float[] fArray = floatMatrix.A[n];
        float[] fArray2 = floatMatrix2.A[n2];
        int n4 = floatMatrix.getColumnDimension();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            double d6 = fArray[n3];
            double d7 = fArray2[n3];
            if (Double.isNaN(d6) || Double.isNaN(d7)) continue;
            ++n5;
            d += d6 * d7;
            d3 += d6 * d6;
            d5 += d7 * d7;
            d2 += d6;
            d4 += d7;
        }
        if (n5 == 0) {
            return 0.0f;
        }
        n3 = 0;
        for (int i = 1; i < n4; ++i) {
            if (Float.isNaN(fArray[i]) || Float.isNaN(fArray2[i])) continue;
            if (fArray[i] != fArray[i - 1]) {
                n3 = 1;
                break;
            }
            if (fArray2[i] == fArray2[i - 1]) continue;
            n3 = 1;
            break;
        }
        if (n3 == 0) {
            return 1.0f;
        }
        double d8 = d2 / (double)n5;
        double d9 = d4 / (double)n5;
        double d10 = d - d2 * d9 - d8 * d4 + d8 * d9 * (double)n5;
        double d11 = d3 - d8 * d2 * 2.0 + d8 * d8 * (double)n5;
        double d12 = d5 - d9 * d4 * 2.0 + d9 * d9 * (double)n5;
        double d13 = d11 * d12;
        return (float)(d10 / (Math.sqrt(d13) + Double.MIN_VALUE) * (double)f);
    }

    public static float geneCosine(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            d4 = floatMatrix.get(n, i);
            d5 = floatMatrix2.get(n2, i);
            d += d4 * d5;
            d2 += d4 * d4;
            d3 += d5 * d5;
            ++n4;
        }
        return (float)(d / (Math.sqrt(d2) * Math.sqrt(d3)) * (double)f);
    }

    public static float geneCovariance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d2 += (double)floatMatrix.get(n, n3);
            d3 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d2 /= (double)n5;
        d3 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d4 = (double)floatMatrix.get(n, n3) - d2;
            double d5 = (double)floatMatrix2.get(n2, n3) - d3;
            d += d4 * d5;
        }
        return (float)(d / ((double)(n5 - 1) * 1.0) * (double)f);
    }

    public static float geneEuclidianDistance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            d += Math.pow(floatMatrix.get(n, i) - floatMatrix2.get(n2, i), 2.0);
            ++n4;
        }
        return (float)(Math.sqrt(d) * (double)f);
    }

    public static float geneDotProduct(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            d += (double)(floatMatrix.get(n, i) * floatMatrix2.get(n2, i));
            ++n4;
        }
        return (float)(d / (double)n4 * (double)f);
    }

    public static float genePearsonUncentered(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f2 = Float.MIN_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d4 += (double)floatMatrix.get(n, n3);
            d5 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d4 /= (double)n5;
        d5 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d6 = floatMatrix.get(n, n3);
            double d7 = floatMatrix2.get(n2, n3);
            d += d6 * d6;
            d2 += d7 * d7;
            d3 += d6 * d7;
        }
        return (float)(d3 / (Math.sqrt(d * d2) + (double)f2) * (double)f);
    }

    public static float geneManhattan(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            d += (double)Math.abs(floatMatrix.get(n, i) - floatMatrix.get(n2, i));
        }
        return (float)(d * (double)f);
    }

    public static float geneSpearmanRank(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n4 = floatMatrix.getColumnDimension();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = floatMatrix.get(n, n3);
            dArray2[n3] = floatMatrix2.get(n2, n3);
        }
        ExperimentUtil.sort2(dArray, dArray2);
        double d = ExperimentUtil.crank(dArray);
        ExperimentUtil.sort2(dArray2, dArray);
        double d2 = ExperimentUtil.crank(dArray2);
        double d3 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d3 += Math.pow(dArray[n3] - dArray2[n3], 2.0);
        }
        double d4 = n4;
        double d5 = d4 * d4 * d4 - d4;
        double d6 = d5 / 6.0 - (d + d2) / 12.0;
        double d7 = (1.0 - d / d5) * (1.0 - d2 / d5);
        double d8 = (d4 - 1.0) * d4 * d4 * Math.pow(d4 + 1.0, 2.0) / 36.0 * d7;
        return (float)((1.0 - 6.0 / d5 * (d3 + (d + d2) / 12.0)) / Math.sqrt(d7) * (double)f);
    }

    public static float geneKendallsTau(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f2 = Float.MIN_VALUE;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            for (int j = i + 1; j < n3; ++j) {
                double d;
                double d2 = floatMatrix.get(n, i) - floatMatrix.get(n, j);
                double d3 = d2 * (d = (double)(floatMatrix2.get(n2, i) - floatMatrix2.get(n2, j)));
                if (d3 != 0.0) {
                    ++n5;
                    ++n4;
                    if (d3 > 0.0) {
                        ++n6;
                        continue;
                    }
                    --n6;
                    continue;
                }
                if (d2 != 0.0) {
                    ++n5;
                }
                if (d == 0.0) continue;
                ++n4;
            }
        }
        return (float)((double)n6 / (Math.sqrt(n5) * Math.sqrt(n4) + (double)f2) * (double)f);
    }

    public static float geneMutualInformation(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n4 = floatMatrix2.getColumnDimension();
        int n5 = (int)Math.floor(Math.log(n4) / Math.log(2.0));
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix2.get(n2, i))) continue;
            ++n6;
        }
        FloatMatrix floatMatrix3 = new FloatMatrix(n6, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(n6, 1);
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            if (Float.isNaN(floatMatrix.get(n, i)) || Float.isNaN(floatMatrix.get(n2, i))) continue;
            floatMatrix3.set(n7, 0, floatMatrix.get(n, i));
            floatMatrix4.set(n7, 0, floatMatrix2.get(n2, i));
            ++n7;
        }
        n4 = n6;
        ExperimentUtil.makeDigitalExperiment(floatMatrix3, 0);
        ExperimentUtil.makeDigitalExperiment(floatMatrix4, 0);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n5][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = (int)floatMatrix3.get(0, n3) - 1;
            dArray[n8] = dArray[n8] + 1.0;
            int n9 = (int)floatMatrix4.get(0, n3) - 1;
            dArray2[n9] = dArray2[n9] + 1.0;
            double[] dArray4 = dArray3[(int)floatMatrix3.get(0, n3) - 1];
            int n10 = (int)floatMatrix4.get(0, n3) - 1;
            dArray4[n10] = dArray4[n10] + 1.0;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            int n11 = n3;
            dArray[n11] = dArray[n11] / (double)n4;
            int n12 = n3;
            dArray2[n12] = dArray2[n12] / (double)n4;
            int n13 = 0;
            while (n13 < dArray.length) {
                double[] dArray5 = dArray3[n3];
                int n14 = n13++;
                dArray5[n14] = dArray5[n14] / (double)n4;
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != 0.0) {
                d += dArray[i] * Math.log(dArray[i]) / Math.log(2.0);
            }
            if (dArray2[i] != 0.0) {
                d2 += dArray2[i] * Math.log(dArray2[i]) / Math.log(2.0);
            }
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray3[i][j] == 0.0) continue;
                d3 += dArray3[i][j] * Math.log(dArray3[i][j]) / Math.log(2.0);
            }
        }
        d = -d;
        d2 = -d2;
        d3 = -d3;
        d4 = (d + d2 - d3) / Math.max(d, d2);
        return (float)((1.0 - d4) * (double)f);
    }

    public static float pearson(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3;
        float f2 = Float.MIN_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d4 += (double)floatMatrix.get(n3, n);
            d5 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d4 /= (double)n5;
        d5 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d6 = (double)floatMatrix.get(n3, n) - d4;
            double d7 = (double)floatMatrix.get(n3, n2) - d5;
            d += d6 * d6;
            d2 += d7 * d7;
            d3 += d6 * d7;
        }
        return (float)(d3 / (Math.sqrt(d * d2) + (double)f2) * (double)f);
    }

    public static float cosine(FloatMatrix floatMatrix, int n, int n2, float f) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            d4 = floatMatrix.get(i, n);
            d5 = floatMatrix.get(i, n2);
            d += d4 * d5;
            d2 += d4 * d4;
            d3 += d5 * d5;
        }
        return (float)(d / (Math.sqrt(d2) * Math.sqrt(d3)) * (double)f);
    }

    public static float covariance(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d2 += (double)floatMatrix.get(n3, n);
            d3 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d2 /= (double)n5;
        d3 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d4 = (double)floatMatrix.get(n3, n) - d2;
            double d5 = (double)floatMatrix.get(n3, n2) - d3;
            d += d4 * d5;
        }
        return (float)(d / (double)((float)(n5 - 1) * 1.0f) * (double)f);
    }

    public static float euclidian(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3 = floatMatrix.getRowDimension();
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            d += Math.pow(floatMatrix.get(i, n) - floatMatrix.get(i, n2), 2.0);
        }
        return (float)(Math.sqrt(d) * (double)f);
    }

    public static float dotProduct(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3 = floatMatrix.getRowDimension();
        double d = 0.0;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            d += (double)(floatMatrix.get(i, n) * floatMatrix.get(i, n2));
            ++n4;
        }
        return (float)(d / (double)n4 * (double)f);
    }

    public static float pearsonUncentered(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3;
        float f2 = Float.MIN_VALUE;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d4 += (double)floatMatrix.get(n3, n);
            d5 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d4 /= (double)n5;
        d5 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d6 = floatMatrix.get(n3, n);
            double d7 = floatMatrix.get(n3, n2);
            d += d6 * d6;
            d2 += d7 * d7;
            d3 += d6 * d7;
        }
        return (float)(d3 / (Math.sqrt(d * d2) + (double)f2) * (double)f);
    }

    public static float manhattan(FloatMatrix floatMatrix, int n, int n2, float f) {
        double d = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (int i = 0; i < n3; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            d += (double)Math.abs(floatMatrix.get(i, n) - floatMatrix.get(i, n2));
        }
        return (float)(d * (double)f);
    }

    public static float spearmanRank(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3;
        int n4 = floatMatrix.getRowDimension();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = floatMatrix.get(n3, n);
            dArray2[n3] = floatMatrix.get(n3, n2);
        }
        ExperimentUtil.sort2(dArray, dArray2);
        double d = ExperimentUtil.crank(dArray);
        ExperimentUtil.sort2(dArray2, dArray);
        double d2 = ExperimentUtil.crank(dArray2);
        double d3 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d3 += Math.pow(dArray[n3] - dArray2[n3], 2.0);
        }
        double d4 = n4;
        double d5 = d4 * d4 * d4 - d4;
        double d6 = d5 / 6.0 - (d + d2) / 12.0;
        double d7 = (1.0 - d / d5) * (1.0 - d2 / d5);
        double d8 = (d4 - 1.0) * d4 * d4 * Math.pow(d4 + 1.0, 2.0) / 36.0 * d7;
        return (float)((1.0 - 6.0 / d5 * (d3 + (d + d2) / 12.0)) / Math.sqrt(d7) * (double)f);
    }

    public static float kendallsTau(FloatMatrix floatMatrix, int n, int n2, float f) {
        float f2 = Float.MIN_VALUE;
        int n3 = floatMatrix.getRowDimension();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            for (int j = i + 1; j < n3; ++j) {
                double d;
                double d2 = floatMatrix.get(i, n) - floatMatrix.get(j, n);
                double d3 = d2 * (d = (double)(floatMatrix.get(i, n2) - floatMatrix.get(j, n2)));
                if (d3 != 0.0) {
                    ++n5;
                    ++n4;
                    if (d3 > 0.0) {
                        ++n6;
                        continue;
                    }
                    --n6;
                    continue;
                }
                if (d2 != 0.0) {
                    ++n5;
                }
                if (d == 0.0) continue;
                ++n4;
            }
        }
        return (float)((double)n6 / (Math.sqrt(n5) * Math.sqrt(n4) + (double)f2) * (double)f);
    }

    public static float mutualInformation(FloatMatrix floatMatrix, int n, int n2, float f) {
        int n3;
        int n4 = floatMatrix.getRowDimension();
        int n5 = (int)Math.floor(Math.log(n4) / Math.log(2.0));
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            ++n6;
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(1, n6);
        FloatMatrix floatMatrix3 = new FloatMatrix(1, n6);
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            if (Float.isNaN(floatMatrix.get(i, n)) || Float.isNaN(floatMatrix.get(i, n2))) continue;
            floatMatrix2.set(n7, 0, floatMatrix.get(i, n));
            floatMatrix3.set(n7, 0, floatMatrix.get(i, n2));
            ++n7;
        }
        n4 = n6;
        ExperimentUtil.makeDigitalExperiment(floatMatrix2, 0);
        ExperimentUtil.makeDigitalExperiment(floatMatrix3, 0);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n5][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = (int)floatMatrix2.get(n3, 0) - 1;
            dArray[n8] = dArray[n8] + 1.0;
            int n9 = (int)floatMatrix3.get(n3, 0) - 1;
            dArray2[n9] = dArray2[n9] + 1.0;
            double[] dArray4 = dArray3[(int)floatMatrix2.get(n3, 0) - 1];
            int n10 = (int)floatMatrix3.get(n3, 0) - 1;
            dArray4[n10] = dArray4[n10] + 1.0;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            int n11 = n3;
            dArray[n11] = dArray[n11] / (double)n4;
            int n12 = n3;
            dArray2[n12] = dArray2[n12] / (double)n4;
            int n13 = 0;
            while (n13 < dArray.length) {
                double[] dArray5 = dArray3[n3];
                int n14 = n13++;
                dArray5[n14] = dArray5[n14] / (double)n4;
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != 0.0) {
                d += dArray[i] * Math.log(dArray[i]) / Math.log(2.0);
            }
            if (dArray2[i] != 0.0) {
                d2 += dArray2[i] * Math.log(dArray2[i]) / Math.log(2.0);
            }
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray3[i][j] == 0.0) continue;
                d3 += dArray3[i][j] * Math.log(dArray3[i][j]) / Math.log(2.0);
            }
        }
        d = -d;
        d2 = -d2;
        d3 = -d3;
        d4 = Math.max(d, d2) != 0.0 ? (d + d2 - d3) / Math.max(d, d2) : d + d2 - d3;
        return (float)((1.0 - d4) * (double)f);
    }

    public static void makeDigitalExperiment(FloatMatrix floatMatrix, int n) {
        int n2;
        int n3 = floatMatrix.getRowDimension();
        int n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0));
        int n5 = 1000000 / n4;
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) < f)) continue;
            f = floatMatrix.get(n2, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatMatrix.set(n2, n, floatMatrix.get(n2, n) - f);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) > f2)) continue;
            f2 = floatMatrix.get(n2, n);
        }
        if (f2 != 0.0f) {
            for (n2 = 0; n2 < n3; ++n2) {
                floatMatrix.set(n2, n, floatMatrix.get(n2, n) / f2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((double)floatMatrix.get(n2, n) == 1.0) {
                floatMatrix.set(n2, n, n4);
                continue;
            }
            floatMatrix.set(n2, n, (float)(Math.floor(floatMatrix.get(n2, n) * 1000000.0f / (float)n5) + 1.0));
        }
    }

    public static double crank(double[] dArray) {
        int n = 0;
        double d = 0.0;
        int n2 = dArray.length;
        while (n < n2 - 1) {
            int n3;
            if (dArray[n + 1] != dArray[n]) {
                dArray[n] = n;
                ++n;
                continue;
            }
            for (n3 = n + 1; n3 < n2 && dArray[n3] == dArray[n]; ++n3) {
            }
            double d2 = 0.5 * (double)(n + n3 - 1);
            for (int i = n; i <= n3 - 1; ++i) {
                dArray[i] = d2;
            }
            double d3 = n3 - n;
            d += d3 * d3 * d3 - d3;
            n = n3;
        }
        if (n == n2 - 1) {
            dArray[n2 - 1] = n2 - 1;
        }
        return d;
    }

    public static void sort2(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[50];
        while (true) {
            int n5;
            double d;
            double d2;
            int n6;
            if (n2 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n2; ++n6) {
                    d2 = dArray[n6];
                    d = dArray2[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(dArray[n5] <= d2); --n5) {
                        dArray[n5 + 1] = dArray[n5];
                        dArray2[n5 + 1] = dArray2[n5];
                    }
                    dArray[n5 + 1] = d2;
                    dArray2[n5 + 1] = d;
                }
                if (n4 == 0) {
                    nArray = null;
                    return;
                }
                n2 = nArray[n4];
                n3 = nArray[n4 - 1];
                n4 -= 2;
                continue;
            }
            int n7 = n3 + n2 >> 1;
            double d3 = dArray[n7];
            dArray[n7] = dArray[n3 + 1];
            dArray[n3 + 1] = dArray[n7];
            d3 = dArray2[n7];
            dArray2[n7] = dArray2[n3 + 1];
            dArray2[n3 + 1] = dArray2[n7];
            if (dArray[n3] > dArray[n2]) {
                d3 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d3;
                d3 = dArray2[n3];
                dArray2[n3] = dArray2[n2];
                dArray2[n2] = d3;
            }
            if (dArray[n3 + 1] > dArray[n2]) {
                d3 = dArray[n3 + 1];
                dArray[n3 + 1] = dArray[n2];
                dArray[n2] = d3;
                d3 = dArray2[n3 + 1];
                dArray2[n3 + 1] = dArray2[n2];
                dArray2[n2] = d3;
            }
            if (dArray[n3] > dArray[n3 + 1]) {
                d3 = dArray[n3];
                dArray[n3] = dArray[n3 + 1];
                dArray[n3 + 1] = d3;
                d3 = dArray2[n3];
                dArray2[n3] = dArray2[n3 + 1];
                dArray2[n3 + 1] = d3;
            }
            n5 = n3 + 1;
            n6 = n2;
            d2 = dArray[n3 + 1];
            d = dArray2[n3 + 1];
            while (true) {
                if (dArray[++n5] < d2) {
                    continue;
                }
                while (dArray[--n6] > d2) {
                }
                if (n6 < n5) break;
                d3 = dArray[n5];
                dArray[n5] = dArray[n6];
                dArray[n6] = d3;
                d3 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d3;
            }
            dArray[n3 + 1] = dArray[n6];
            dArray[n6] = d2;
            dArray2[n3 + 1] = dArray2[n6];
            dArray2[n6] = d;
            if ((n4 += 2) > 50) {
                System.out.println("NSTACK too small in sort2.");
            }
            if (n2 - n5 + 1 >= n6 - n3) {
                nArray[n4] = n2;
                nArray[n4 - 1] = n5;
                n2 = n6 - 1;
                continue;
            }
            nArray[n4] = n6 - 1;
            nArray[n4 - 1] = n3;
            n3 = n5;
        }
    }
}

