/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.Versioned;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import org.slf4j.Logger;
import xtools.api.CanceledException;

public class ToolHelper {
    public static boolean checkNonMixedVersions(Chip chip, GeneSet[] geneSets) throws Exception {
        boolean allKnown;
        if (geneSets == null || geneSets.length == 0) {
            throw new IllegalArgumentException("One or more gene sets must be specified");
        }
        MSigDBVersion first = geneSets[0].getMSigDBVersion();
        boolean allUnknown = first.isUnknownVersion();
        boolean bl = allKnown = !first.isUnknownVersion();
        if (geneSets.length > 1) {
            for (int i = 1; i < geneSets.length; ++i) {
                MSigDBVersion currVer = geneSets[i].getMSigDBVersion();
                if (!currVer.isUnknownVersion()) {
                    if (!first.equals(currVer)) {
                        return false;
                    }
                    allUnknown = false;
                    allKnown &= true;
                    continue;
                }
                allUnknown &= true;
                allKnown = false;
            }
        }
        if (chip != null) {
            MSigDBVersion chipVersion = chip.getMSigDBVersion();
            if (!chipVersion.isUnknownVersion()) {
                if (!first.equals(chipVersion)) {
                    return false;
                }
                allUnknown = false;
                allKnown &= true;
            } else {
                allUnknown &= true;
                allKnown = false;
            }
        }
        return allUnknown || allKnown;
    }

    public static boolean checkNonMixedSpecies(Chip chip, GeneSet[] geneSets) throws Exception {
        if (geneSets == null || geneSets.length == 0) {
            throw new IllegalArgumentException("One or more gene sets must be specified");
        }
        if (chip != null) {
            chip.getNumProbes();
        }
        ArrayList<GeneSet> geneSetsList = new ArrayList<GeneSet>(Arrays.asList(geneSets));
        geneSetsList.removeIf((Predicate<GeneSet>)new Predicate<Versioned>(){

            @Override
            public boolean test(Versioned item) {
                return item.getMSigDBVersion().isUnknownVersion();
            }
        });
        if (geneSetsList.isEmpty()) {
            return true;
        }
        MSigDBVersion first = ((GeneSet)geneSetsList.remove(0)).getMSigDBVersion();
        for (Versioned versioned : geneSetsList) {
            if (first.getMsigDBSpecies() == versioned.getMSigDBVersion().getMsigDBSpecies()) continue;
            return false;
        }
        if (chip == null) {
            return true;
        }
        MSigDBVersion chipVersion = chip.getMSigDBVersion();
        return !chipVersion.isUnknownVersion() && first.getMsigDBSpecies() == chipVersion.getMsigDBSpecies();
    }

    public static void validateMixedVersionAndSpecies(GeneSet[] origGeneSets, Chip chip, ToolReport toolReport, Logger log) throws Exception {
        if (!ToolHelper.checkNonMixedSpecies(chip, origGeneSets)) {
            String msg = chip != null ? "Selected CHIP is not compatible with the selected gene set(s) species" : "GSEA doesn't support simultaneous selection of human and mouse MSigDB collections";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!ToolHelper.checkNonMixedVersions(chip, origGeneSets)) {
            if (chip == null) {
                String msgShort = "Mixed MSigDB versions detected";
                String msgFull = "Selecting collections from multiple MSigDB versions may result in omitted genes and is not recommended.";
                log.warn(msgShort);
                log.warn(msgFull);
                toolReport.addWarning(msgShort + ". " + msgFull);
            } else {
                String msgShort = "Mixed MSigDB versions detected";
                String msgPt1 = "The selected CHIP does not match the version of the MSigDB";
                String msgPt2 = "collection selected. Some gene identifiers may not be mapped.";
                try {
                    boolean confirm = Application.getWindowManager().showConfirm(msgShort, String.join((CharSequence)"\n", msgPt1, msgPt2));
                    if (!confirm) {
                        throw new CanceledException();
                    }
                }
                catch (NotImplementedException | HeadlessException confirm) {
                    // empty catch block
                }
                log.warn(msgShort);
                String msgFull = msgPt1 + " " + msgPt2;
                log.warn(msgFull);
                toolReport.addWarning(msgShort + ". " + msgFull);
            }
        }
    }
}

