/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import xtools.api.param.AbstractParam;
import xtools.api.param.Param;
import xtools.api.param.ParamHelper;

public class BooleanParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    public BooleanParam(String name, String desc, boolean reqd) {
        super(name, Boolean.class, desc, new Boolean(reqd), (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, reqd);
    }

    public BooleanParam(String name, String nameEnglish, String desc, boolean def, boolean reqd) {
        super(name, nameEnglish, Boolean.class, desc, (Object)new Boolean(def), (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, reqd);
    }

    public BooleanParam(String name, String nameEnglish, String desc, boolean def, boolean reqd, Param.Type type) {
        super(name, nameEnglish, Boolean.class, desc, (Object)new Boolean(def), (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, reqd, type);
    }

    public BooleanParam(String name, String desc, boolean def, boolean reqd) {
        super(name, Boolean.class, desc, new Boolean(def), (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof Boolean) {
            super.setValue(value);
        } else if (value instanceof String) {
            this.setValue((String)value);
        } else {
            throw new IllegalArgumentException("Invalid type, only Boolean accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    public void setValue(Boolean value) {
        super.setValue(value);
    }

    public void setValue(String trueorfalse) {
        this.setValue(Boolean.valueOf(trueorfalse));
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    public boolean isTrue() {
        Object val = this.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (Boolean)val;
    }

    public boolean isFalse() {
        Object val = this.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        boolean valb = (Boolean)val;
        return !valb;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(false, (ActionListener)this, this);
            ParamHelper.safeSelectValueDefaultOrNone(this.cbOptions.getComboBox(), this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue(((JComboBox)this.cbOptions.getComponent()).getSelectedItem());
    }
}

