/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.objects.GeneSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.heatmap.GradientColorScheme;
import org.genepattern.heatmap.HeatMapComponent;
import org.genepattern.heatmap.HeatMapPanel;

public class GeneSetSimilarityPanel {
    HeatMapComponent heatMap;
    JPanel legend;
    private static final int JACCARD = 0;
    private static final int HYPER_GEOM = 1;
    private static final int SIM = 2;
    private int similarityMeasure = 0;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private GeneSet[] geneSets;

    public GeneSetSimilarityPanel(Frame parent) {
        this.numberFormat.setMaximumFractionDigits(4);
        GradientColorScheme colorScheme = new GradientColorScheme(0.0, 1.0, 0.5, Color.GREEN, Color.RED, Color.WHITE);
        colorScheme.setUseDoubleGradient(false);
        this.legend = (JPanel)colorScheme.getLegend();
        this.heatMap = new HeatMapComponent(parent, IExpressionDataUtil.createRandomData(1, 1), this.legend);
        this.heatMap.getHeatMapPanel().setUpperTriangular(true);
        this.heatMap.getHeatMapPanel().setToolTipProvider(new HeatMapPanel.ToolTipProvider(){

            @Override
            public String getToolTipText(int row, int column) {
                IExpressionData data = GeneSetSimilarityPanel.this.heatMap.getExpressionData();
                String value = GeneSetSimilarityPanel.this.numberFormat.format(data.getValue(row, column));
                int intersection = AlgUtils.intersectSize(GeneSetSimilarityPanel.this.geneSets[row], GeneSetSimilarityPanel.this.geneSets[column]);
                int union = AlgUtils.unionAllCount(new GeneSet[]{GeneSetSimilarityPanel.this.geneSets[row], GeneSetSimilarityPanel.this.geneSets[column]});
                return "<html>" + value + " (intersection=" + intersection + ", union=" + union + ")<br>" + data.getRowName(row) + " (size=" + GeneSetSimilarityPanel.this.geneSets[row].getNumMembers() + ")<br>" + data.getColumnName(column) + " (size=" + GeneSetSimilarityPanel.this.geneSets[column].getNumMembers() + ")";
            }
        });
        this.heatMap.setFeatureUIString("Gene Set");
        this.heatMap.setSampleUIString("Gene Set");
        this.heatMap.setShowFeatureAnnotator(false);
        this.heatMap.setShowSampleAnnotator(false);
        this.heatMap.setShowColorSchemeOptions(false);
        this.heatMap.setShowRowDescriptions(false);
        this.heatMap.setRowSize(12);
        this.heatMap.setColumnSize(12);
        this.heatMap.setColorConverter(colorScheme);
        this.heatMap.setShowFeatureTableHeader(false);
        this.heatMap.getHeatMapPanel().addPropertyChangeListener("columnSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer newValue = (Integer)evt.getNewValue();
                Dimension size = GeneSetSimilarityPanel.this.legend.getPreferredSize();
                size.width = GeneSetSimilarityPanel.this.heatMap.getExpressionData().getColumnCount() * newValue;
                GeneSetSimilarityPanel.this.legend.setPreferredSize(size);
            }
        });
    }

    public void setGeneSets(GeneSet[] geneSets) {
        this.geneSets = geneSets;
        double[][] similarityMatrix = new double[geneSets.length][geneSets.length];
        String[] names = new String[geneSets.length];
        for (int i = 0; i < geneSets.length; ++i) {
            names[i] = geneSets[i].getName(true);
            for (int j = i; j < geneSets.length; ++j) {
                double sim;
                int intersection = AlgUtils.intersectSize(geneSets[i], geneSets[j]);
                int union = AlgUtils.unionAllCount(new GeneSet[]{geneSets[i], geneSets[j]});
                int geneSet_i_size = geneSets[i].getNumMembers();
                int geneSet_j_size = geneSets[j].getNumMembers();
                if (this.similarityMeasure == 0) {
                    double jaccard;
                    similarityMatrix[i][j] = jaccard = (double)intersection / (double)union;
                    continue;
                }
                if (this.similarityMeasure == 1) {
                    int populationSize = union;
                    int numberOfSuccesses = geneSet_i_size;
                    int sampleSize = geneSet_j_size;
                    int n = intersection;
                    continue;
                }
                if (this.similarityMeasure != 2) continue;
                similarityMatrix[i][j] = sim = Math.sqrt(intersection / geneSets[i].getNumMembers() * (intersection / geneSets[j].getNumMembers()));
            }
        }
        DoubleMatrix2D matrix = new DoubleMatrix2D(similarityMatrix, names, names);
        ExpressionData data = new ExpressionData(matrix, null, null);
        this.heatMap.setExpressionData(data);
        Dimension size = this.legend.getPreferredSize();
        size.width = this.heatMap.getExpressionData().getColumnCount() * this.heatMap.getHeatMapPanel().getColumnSize();
        this.legend.setPreferredSize(size);
    }

    public HeatMapComponent getHeatMapComponent() {
        return this.heatMap;
    }

    public JMenuBar getMenuBar() {
        this.heatMap.setOptionsDialogOptions(false, false, false);
        return this.heatMap.createMenuBar(false, false, false, false);
    }
}

