/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import au.com.pegasustech.demos.layout.PointLayout;
import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.DatasetModel;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.viewers.AbstractViewer;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class DatasetViewer
extends AbstractViewer {
    public static final String NAME = "DatasetViewer";
    public static final Icon ICON = JarResources.getIcon("Res16.gif");
    private final Dataset fDataset;

    public DatasetViewer(Dataset ds) {
        super(NAME, ICON, ds);
        this.fDataset = ds;
        this.jbInit();
    }

    private void jbInit() {
        DatasetModel dmodel = new DatasetModel(this.fDataset);
        SortableTable table = DatasetViewer.createTable(dmodel, true, true);
        table.setAutoResizeMode(0);
        this.setLayout((LayoutManager)new PointLayout());
        JTabbedPane tp = new JTabbedPane(3);
        JScrollPane sp = DatasetViewer.createAlwaysScrollPane((JTable)table);
        tp.addTab("Data", sp);
        tp.addTab("Info", this.getDatasetInfo(this.fDataset));
        this.add(tp);
    }

    private JComponent getDatasetInfo(Dataset ds) {
        StringBuffer buf = new StringBuffer("Name: ").append(ds.getName()).append('\n');
        buf.append("Number of rows(features): ").append(ds.getNumRow()).append('\n');
        buf.append("Num of columns(samples): ").append(ds.getNumCol()).append('\n');
        String comm = ds.getComment();
        if (comm != null && comm.length() > 0) {
            buf.append("\nComments\n");
            buf.append(ds.getComment());
        }
        buf.append("\nColumn Names\n");
        for (int c = 0; c < ds.getNumCol(); ++c) {
            buf.append(ds.getColumnName(c)).append('\n');
        }
        JTextArea ta = new JTextArea(buf.toString());
        return new JScrollPane(ta);
    }
}

