/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListJITImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScoreImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class EdbFolderParser
extends AbstractParser {
    private static final char DELIM = ' ';
    private static final String EDB = "EDB";
    private static final String DTG = "DTG";
    private static final String ES = "ES";
    private static final String RND_ES = "RND_ES";
    private static final String NP = "NP";
    private static final String FDR = "FDR";
    private static final String NES = "NES";
    private static final String FWER = "FWER";
    private static final String CHIP = "CHIP";
    private static final String HIT_INDICES = "HIT_INDICES";
    private static final String RANK_AT_ES = "RANK_AT_ES";
    private static final String RANK_SCORE_AT_ES = "RANK_SCORE_AT_ES";
    private static final String ES_PROFILE = "ES_PROFILE";
    private static final String EDB_FILE_NAME = "results.edb";
    private Map<String, RankedList> rankedListNameRankedListObject;
    private Map<String, File> fPobidFileMap;

    public EdbFolderParser() {
        super(EnrichmentDb.class);
    }

    protected EnrichmentDb parseEdb(File gseaResultDir) throws Exception {
        Boolean use_biased;
        Boolean fix_low;
        File edb_dir = EdbFolderParser._getEdbDir(gseaResultDir);
        File edb_file = new File(edb_dir, EDB_FILE_NAME);
        if (!edb_file.exists()) {
            throw new IllegalArgumentException("edb file not found: " + edb_file);
        }
        FileInputStream is = new FileInputStream(edb_file);
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)is);
        Element root = document.getRootElement();
        SortMode sort = SortMode.lookup(root.attribute("SORT_MODE").getValue());
        Order order = Order.lookup(root.attribute("ORDER").getValue());
        Metric metric = Metrics.lookupMetric(root.attribute("METRIC").getValue());
        int numPerms = Integer.parseInt(root.attribute("NUM_PERMS").getValue());
        ArrayList<EnrichmentResult> dtgs = new ArrayList<EnrichmentResult>();
        int cnt = 0;
        Iterator<Element> i = this.getDomIterator(root);
        while (i.hasNext()) {
            Element el = i.next();
            Template template_opt = null;
            try {
                template_opt = ParserFactory.readTemplate(EdbFolderParser._toFile("TEMPLATE", el, edb_dir), true, false, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GeneSet gset = ParserFactory.readGeneSet(EdbFolderParser._toFile("GENESET", el, edb_dir), true, false);
            RankedList rl = this._readRankedList(el, edb_dir);
            float es = Float.parseFloat(el.attribute(ES).getValue());
            float nes = Float.parseFloat(el.attribute(NES).getValue());
            float np = Float.parseFloat(el.attribute(NP).getValue());
            float fdr = Float.parseFloat(el.attribute(FDR).getValue());
            float fwer = Float.parseFloat(el.attribute(FWER).getValue());
            float corrAtES = Float.parseFloat(el.attribute(RANK_SCORE_AT_ES).getValue());
            int rankAtES = (int)Float.parseFloat(el.attribute(RANK_AT_ES).getValue());
            Vector rndESS = EdbFolderParser._toVectorReqd(RND_ES, el);
            Vector esProfile = EdbFolderParser._toVectorReqd(ES_PROFILE, el);
            int[] hitIndices = ParseUtils.string2ints(el.attribute(HIT_INDICES).getValue(), ' ');
            Chip chip = null;
            Attribute chip_name = el.attribute(CHIP);
            if (chip_name != null && chip_name.getValue() != null && chip_name.getValue().length() > 0) {
                chip = VdbRuntimeResources.getChip(chip_name.getValue());
            }
            EnrichmentScoreImpl score = new EnrichmentScoreImpl(es, rankAtES, corrAtES, nes, np, fdr, fwer, hitIndices.length, hitIndices, esProfile, null);
            dtgs.add(new EnrichmentResult(rl, template_opt, gset, chip, score, rndESS, null));
            if (cnt % 500 == 0) {
                System.out.println("read in from edb dtg: " + (cnt + 1));
            }
            ++cnt;
        }
        HashMap<String, Boolean> mps = new HashMap<String, Boolean>();
        Boolean use_median = EdbFolderParser._boolean(root, "USE_MEDIAN");
        if (use_median != null) {
            mps.put("USE_MEDIAN", use_median);
        }
        if ((fix_low = EdbFolderParser._boolean(root, "FIX_LOW")) != null) {
            mps.put("FIX_LOW", fix_low);
        }
        if ((use_biased = EdbFolderParser._boolean(root, "USE_BIASED")) != null) {
            mps.put("USE_BIASED", use_biased);
        }
        EnrichmentResult[] results = dtgs.toArray(new EnrichmentResult[dtgs.size()]);
        RankedList rankedList = this._rl_shared(results);
        Template template = this.template_shared(results);
        EnrichmentDb edb = new EnrichmentDb(NamingConventions.removeExtension(edb_file.getName()), rankedList, null, template, results, metric, mps, sort, order, numPerms, edb_dir, null);
        edb.addComment(this.fComment.toString());
        this.doneImport();
        return edb;
    }

    private final Iterator<Element> getDomIterator(Element root) {
        return root.elementIterator(DTG);
    }

    private RankedList _rl_shared(EnrichmentResult[] results) {
        Errors errors = new Errors();
        String theName = results[0].getRankedList().getName();
        int theSize = results[0].getRankedList().getSize();
        for (int r = 0; r < results.length; ++r) {
            String name = results[r].getRankedList().getName();
            int size = results[r].getRankedList().getSize();
            if (!name.equals(theName)) {
                errors.add("Mismatched rl theName: " + theName + " name: " + name + " at r: " + r + " # rls: " + results.length);
            }
            if (size == theSize) continue;
            errors.add("Mismatched rl theName: " + theName + " name: " + name + " at r: " + r + " # rls: " + results.length);
        }
        errors.barfIfNotEmptyRuntime();
        return results[0].getRankedList();
    }

    private Template template_shared(EnrichmentResult[] results) {
        Errors errors = new Errors();
        if (results[0].getTemplate() == null) {
            return null;
        }
        String theName = results[0].getTemplate().getName();
        for (int r = 0; r < results.length; ++r) {
            String name = results[r].getTemplate().getName();
            if (name.equals(theName)) continue;
            errors.add("Mismatched template theName: " + theName + " name: " + name + " at r: " + r + " # results: " + results.length);
        }
        errors.barfIfNotEmptyRuntime();
        return results[0].getTemplate();
    }

    private static File _getEdbDir(File gseaResultDir) throws ParserException {
        File edb_dir;
        if (!gseaResultDir.exists() || !gseaResultDir.isDirectory()) {
            throw new ParserException("Invalid gsea dir for parsing ... expecting a dir, got: " + gseaResultDir);
        }
        if (gseaResultDir.getName().equals("edb")) {
            edb_dir = gseaResultDir;
        } else {
            edb_dir = new File(gseaResultDir, "edb");
            if (!edb_dir.exists()) {
                throw new IllegalArgumentException("edb dir not found: " + edb_dir);
            }
        }
        return edb_dir;
    }

    private static Vector _toVectorReqd(String attName, Element el) throws ParserException {
        EdbFolderParser.barfIfMissing(attName, el);
        return ParseUtils.string2Vector(el.attribute(attName).getValue(), ' ');
    }

    private static void barfIfMissing(String attName, Element el) throws ParserException {
        if (el.attribute(attName).getValue() == null || el.attribute(attName).getValue().length() == 0) {
            throw new ParserException("Missing attribute " + attName + " in element: " + el.getName());
        }
    }

    @Override
    public List parse(String sourcepath, InputStream fis) throws Exception {
        this.startImport(sourcepath);
        EnrichmentDb edb = this.parseEdb(new File(sourcepath));
        return EdbFolderParser.unmodlist(edb);
    }

    @Override
    public void export(PersistentObject pob_edb, File gseaResultDir) throws Exception {
        boolean made;
        boolean made2;
        if (pob_edb == null) {
            throw new IllegalArgumentException("Param pob_edb cannot be null");
        }
        if (gseaResultDir == null) {
            throw new IllegalArgumentException("Param foo cannot be null: " + gseaResultDir);
        }
        if (!gseaResultDir.exists() && !(made2 = gseaResultDir.mkdir())) {
            throw new IllegalArgumentException("Could not make gsea result dir: " + gseaResultDir);
        }
        File edb_dir = new File(gseaResultDir, "edb");
        if (!edb_dir.exists() && !(made = edb_dir.mkdir())) {
            throw new IllegalArgumentException("Could not make edb dir: " + edb_dir);
        }
        this.export(pob_edb, edb_dir, EDB_FILE_NAME, null, true, true);
    }

    public void export(PersistentObject pob_edb, File saveInThisDir, String edb_file_name, String force_this_rnk_name_opt, boolean exportTemplateIfAvailable, boolean exportTheGeneSetMatrix) throws Exception {
        Boolean use_biased;
        Boolean fix_low;
        if (pob_edb == null) {
            throw new IllegalArgumentException("Param pob_edb cannot be null");
        }
        EnrichmentDb edb = (EnrichmentDb)pob_edb;
        Struc struc = new Struc(edb.getNumResults());
        if (exportTheGeneSetMatrix) {
            HashSet<String> names = new HashSet<String>();
            ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
            for (int i = 0; i < edb.getNumResults(); ++i) {
                GeneSet gset = edb.getResult(i).getGeneSet();
                String name = gset.getName(true);
                if (names.contains(name)) continue;
                GeneSet cgset = gset.cloneShallow(name);
                gsets.add(cgset);
                names.add(name);
            }
            DefaultGeneSetMatrix gm = new DefaultGeneSetMatrix("gene_sets", gsets, null);
            struc.gmFile = NamingConventions.createSafeFile(saveInThisDir, gm.getName() + ".gmt");
            ParserFactory.saveGmt(gm, struc.gmFile, false);
        } else {
            struc.gmFile = new File(saveInThisDir, "gene_sets.gmt");
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(EDB);
        root.addAttribute("LC_PROC", "none");
        root.addAttribute("SORT_MODE", edb.getSortMode().toString());
        root.addAttribute("ORDER", edb.getOrder().toString());
        root.addAttribute("METRIC", edb.getMetric().toString());
        root.addAttribute("NUM_PERMS", "" + edb.getNumPerm());
        Map<String, Boolean> map = edb.getMetricParams();
        Boolean use_median = map.get("USE_MEDIAN");
        if (use_median != null) {
            root.addAttribute("USE_MEDIAN", ((Object)use_median).toString());
        }
        if ((fix_low = map.get("FIX_LOW")) != null) {
            root.addAttribute("FIX_LOW", ((Object)fix_low).toString());
        }
        if ((use_biased = map.get("USE_BIASED")) != null) {
            root.addAttribute("USE_BIASED", ((Object)use_biased).toString());
        }
        for (int i = 0; i < edb.getNumResults(); ++i) {
            EnrichmentResult dtg = edb.getResult(i);
            EnrichmentScore score = dtg.getScore();
            Element el = root.addElement(DTG);
            String fname = force_this_rnk_name_opt != null ? EdbFolderParser._fixExt(force_this_rnk_name_opt, "rnk") : EdbFolderParser._fixExt(dtg.getRankedList().getName(), "rnk");
            struc.rankedListFiles[i] = this.saveIfNeeded(fname, dtg.getRankedList(), saveInThisDir);
            el.addAttribute("RANKED_LIST", fname);
            if (exportTemplateIfAvailable && dtg.getTemplate() != null) {
                String bn = AuxUtils.getBaseNameOnly(dtg.getTemplate().getName());
                fname = EdbFolderParser._fixExt(bn, "cls");
                struc.templateFiles[i] = this.saveIfNeeded(fname, dtg.getTemplate(), saveInThisDir);
                el.addAttribute("TEMPLATE", fname);
            } else {
                el.addAttribute("TEMPLATE", "na_as_pre_ranked");
            }
            el.addAttribute("GENESET", struc.gmFile.getName() + "#" + dtg.getGeneSet().getName(true));
            el.addAttribute(ES, Printf.format(score.getES()));
            el.addAttribute(NES, Printf.format(score.getNES()));
            el.addAttribute(NP, Printf.format(score.getNP()));
            el.addAttribute(FDR, Printf.format(score.getFDR()));
            el.addAttribute(FWER, Printf.format(score.getFWER()));
            if (dtg.getChip() != null) {
                el.addAttribute(CHIP, dtg.getChip().getName());
            }
            el.addAttribute(RND_ES, Printf.format(dtg.getRndESS(), ' '));
            el.addAttribute(HIT_INDICES, Printf.format(score.getHitIndices(), ' '));
            el.addAttribute(ES_PROFILE, Printf.format(score.getESProfile(), ' '));
            el.addAttribute(RANK_AT_ES, Printf.format(score.getRankAtES()));
            el.addAttribute(RANK_SCORE_AT_ES, Printf.format(score.getRankScoreAtES()));
        }
        if (!((String)edb_file_name).endsWith("edb")) {
            edb_file_name = (String)edb_file_name + ".edb";
        }
        File edb_file = new File(saveInThisDir, (String)edb_file_name);
        PrintWriter pw = new PrintWriter(new FileOutputStream(edb_file));
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(edb_file), format);
        writer.write(document);
        writer.close();
        pw.close();
        this.doneExport();
    }

    private static String _fixExt(String name, String expectedExt) {
        if (!((String)name).endsWith("." + expectedExt)) {
            name = (String)name + "." + expectedExt;
        }
        return name;
    }

    private RankedList _readRankedList(Element el, File edb_dir) throws Exception {
        String name;
        if (this.rankedListNameRankedListObject == null) {
            this.rankedListNameRankedListObject = new HashMap<String, RankedList>();
        }
        if ((name = el.attribute("RANKED_LIST").getValue()) == null || name.length() == 0) {
            throw new IllegalArgumentException("No ranked list element in the xml: " + el);
        }
        RankedList rankedList = this.rankedListNameRankedListObject.get(name);
        if (rankedList == null) {
            File file = new File(edb_dir, NamingConventions.createSafeFileName(name));
            rankedList = new RankedListJITImpl(file);
        }
        this.rankedListNameRankedListObject.put(name, rankedList);
        return rankedList;
    }

    private File saveIfNeeded(String name, PersistentObject pob, File inDir) throws Exception {
        String id;
        if (this.fPobidFileMap == null) {
            this.fPobidFileMap = new HashMap<String, File>();
        }
        if (this.fPobidFileMap.containsKey(id = name + "." + pob.getClass().getName())) {
            return this.fPobidFileMap.get(id);
        }
        File file = NamingConventions.createSafeFile(inDir, name);
        if (file.exists()) {
            this.log.warn("Overwriting extant file: {}", (Object)file);
        }
        if (pob instanceof RankedList) {
            ParserFactory.save((RankedList)pob, file);
        } else if (pob instanceof Template) {
            ParserFactory.save((Template)pob, file, false);
        } else {
            throw new IllegalArgumentException("Unknown object: " + pob);
        }
        this.fPobidFileMap.put(id, file);
        return file;
    }

    private static Boolean _boolean(Element el, String attrName) {
        Attribute attr = el.attribute(attrName);
        if (attr == null) {
            return null;
        }
        return Boolean.valueOf(attr.getValue());
    }

    private static File _toFile(String attName, Element el, File inDir) {
        return new File(inDir, el.attribute(attName).getValue());
    }

    static class Struc {
        File[] templateFiles;
        File[] rankedListFiles;
        File gmFile;

        Struc(int numResults) {
            this.templateFiles = new File[numResults];
            this.rankedListFiles = new File[numResults];
        }
    }
}

