/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.destination;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.DBType;
import org.ujmp.core.export.destination.AbstractMatrixFileExportDestination;
import org.ujmp.core.export.exporter.DefaultMatrixWriterCSVExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterLatexExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterMatlabScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterRScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterSQLExporter;

public class DefaultMatrixFileExportDestination
extends AbstractMatrixFileExportDestination {
    public DefaultMatrixFileExportDestination(Matrix matrix, File file) {
        super(matrix, file);
    }

    public void asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        new DefaultMatrixWriterCSVExporter(this.getMatrix(), bufferedWriter).asDenseCSV(columnSeparator, enclosingCharacter);
        bufferedWriter.close();
        fileWriter.close();
    }

    public void asDenseCSV(char columnSeparator) throws IOException {
        this.asDenseCSV(columnSeparator, '\u0000');
    }

    public void asDenseCSV() throws IOException {
        this.asDenseCSV('\t');
    }

    public void asSQL(DBType db, String databaseName, String tableName) throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        new DefaultMatrixWriterSQLExporter(this.getMatrix(), bufferedWriter).asSQL(db, databaseName, tableName);
        bufferedWriter.close();
        fileWriter.close();
    }

    public void asMatlabScript(String variableName) throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        new DefaultMatrixWriterMatlabScriptExporter(this.getMatrix(), bufferedWriter).asMatlabScript(variableName);
        bufferedWriter.close();
        fileWriter.close();
    }

    public void asRScript(String variableName) throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        new DefaultMatrixWriterRScriptExporter(this.getMatrix(), bufferedWriter).asRScript(variableName);
        bufferedWriter.close();
        fileWriter.close();
    }

    public void asLatex() throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        new DefaultMatrixWriterLatexExporter(this.getMatrix(), bufferedWriter).asLatex();
        bufferedWriter.close();
        fileWriter.close();
    }

    public void asXLS() throws IOException {
    }

    public void asPLT(Object ... parameters) throws IOException {
    }
}

