/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.awt.Color;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.ColorMap;
import org.ujmp.core.util.StringUtil;

public abstract class ColorUtil {
    public static final Color[] TRACECOLORS = new Color[]{Color.blue, Color.green, Color.red, Color.black, Color.yellow, Color.cyan};

    public static final Color contrastBW(Color c) {
        if ((double)(c.getRed() + c.getGreen() + c.getBlue()) > 200.0) {
            return Color.black;
        }
        return Color.white;
    }

    public static final Color fromRGB(int v) {
        return new Color(v);
    }

    public static final Color add(Color color1, Color color2) {
        double r1 = color1.getRed();
        double g1 = color1.getGreen();
        double b1 = color1.getBlue();
        double a1 = color1.getAlpha();
        double r2 = color2.getRed();
        double g2 = color2.getGreen();
        double b2 = color2.getBlue();
        double a2 = color2.getAlpha();
        int r = (int)((r1 * a1 / 255.0 + r2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int g = (int)((g1 * a1 / 255.0 + g2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int b = (int)((b1 * a1 / 255.0 + b2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        return new Color(r, g, b);
    }

    public static final Color fromBoolean(boolean v) {
        return v ? Color.GREEN : Color.BLACK;
    }

    public static final Color fromBoolean(boolean v, int alpha) {
        Color c = ColorUtil.fromBoolean(v);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static final Color fromDouble(double v) {
        if (v == Double.MIN_VALUE || Double.isNaN(v)) {
            return Color.MAGENTA;
        }
        if (Double.isInfinite(v)) {
            return Color.CYAN;
        }
        if (v > 1.0) {
            return ColorMap.colorGreenToYellow[(int)(255.0 * Math.tanh((v - 1.0) / 10.0))];
        }
        if (v > 0.0) {
            return ColorMap.colorBlackToGreen[(int)(255.0 * v)];
        }
        if (v > -1.0) {
            return ColorMap.colorRedToBlack[(int)(255.0 * (v + 1.0))];
        }
        return ColorMap.colorRedToMagenta[(int)(255.0 * Math.tanh((-v - 1.0) / 10.0))];
    }

    public static final Color fromDouble(double v, int alpha) {
        Color c = ColorUtil.fromDouble(v);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color fromString(String s) {
        return ColorUtil.fromString(s, 255);
    }

    public static Color fromString(String s, int alpha) {
        if (s == null) {
            return Color.black;
        }
        if ("".equals(s)) {
            return Color.darkGray;
        }
        String lc = s.toLowerCase();
        if ("yes".equals(lc)) {
            return Color.green;
        }
        if ("true".equals(lc)) {
            return Color.green;
        }
        if ("ok".equals(lc)) {
            return Color.green;
        }
        if ("no".equals(lc)) {
            return Color.black;
        }
        if ("false".equals(lc)) {
            return Color.black;
        }
        if ("n/a".equals(lc)) {
            return Color.darkGray;
        }
        if ("error".equals(lc)) {
            return Color.cyan;
        }
        int hc = Math.abs(ColorUtil.hash(s.hashCode()));
        int r = 192 + hc % 256 / 4;
        int g = 192 + (hc /= 256) % 256 / 4;
        int b = 192 + (hc /= 256) % 256 / 4;
        return new Color(r > 255 ? 255 : r, g > 255 ? 255 : g, b > 255 ? 255 : b, alpha);
    }

    public static Color fromObject(Object v) {
        return ColorUtil.fromObject(v, 255);
    }

    public static Color fromObject(Object v, int alpha) {
        if (v == null) {
            return Color.black;
        }
        if (v == "[loading...]") {
            return Color.LIGHT_GRAY;
        }
        if (v instanceof Boolean) {
            return ColorUtil.fromBoolean((Boolean)v, alpha);
        }
        if (v instanceof Double) {
            return ColorUtil.fromDouble((Double)v, alpha);
        }
        if (v instanceof Float) {
            return ColorUtil.fromDouble(((Float)v).floatValue(), alpha);
        }
        if (v instanceof Byte) {
            return ColorUtil.fromDouble((double)((Byte)v).byteValue() / 127.0, alpha);
        }
        if (v instanceof Integer) {
            return ColorUtil.fromRGB((Integer)v);
        }
        if (v instanceof Long) {
            return ColorUtil.fromDouble(((Long)v).longValue(), alpha);
        }
        if (v instanceof Matrix) {
            Matrix m = (Matrix)v;
            String s = m.getClass().getSimpleName();
            if (m.getLabel() != null) {
                s = s + " " + m.getLabel();
            }
            return ColorUtil.fromString(s, alpha);
        }
        String s = StringUtil.format(v);
        try {
            double d = Double.parseDouble(s);
            return ColorUtil.fromDouble(d, alpha);
        }
        catch (Exception exception) {
            return ColorUtil.fromString(s, alpha);
        }
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static String toHtmlColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

