/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEncoderMap
extends AbstractMap<String, String> {
    private static final long serialVersionUID = 1948316336092537067L;
    private final Map<String, byte[]> map;
    private final Charset charset;

    public StringEncoderMap(Map<String, byte[]> map) {
        this(map, Charset.defaultCharset());
    }

    public StringEncoderMap(Map<String, byte[]> map, Charset charset) {
        this.map = map;
        this.charset = charset;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String get(Object key) {
        try {
            byte[] data = this.map.get(key);
            return data == null ? null : new String(data, this.charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public String put(String key, String value) {
        try {
            String oldValue = this.get(key);
            this.map.put(key, value.getBytes(this.charset));
            return oldValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String remove(Object key) {
        String oldValue = this.get(key);
        this.map.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

