/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import java.io.File;
import java.util.Date;

public class ReportStub {
    private String fName;
    private long fTimestamp;
    private transient Date fDate;
    private File fReportFile;
    private Report fReport;
    private String fTsLessName;

    public ReportStub(File rptFile) {
        this.fReportFile = rptFile;
        this.fName = this.fReportFile.getName();
        Object[] rets = NamingConventions.parseReportTimestampFromName(this.fName);
        this.fTimestamp = (Long)rets[1];
        this.fTsLessName = rets[0].toString();
    }

    public String getName() {
        return this.fName;
    }

    public String getName_without_ts() {
        return this.fTsLessName;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public Date getDate() {
        if (this.fDate == null) {
            this.fDate = new Date(this.fTimestamp);
        }
        return this.fDate;
    }

    public File getReportFile() {
        return this.fReportFile;
    }

    public Report getReport(boolean useCache) throws Exception {
        if (this.fReport == null) {
            this.fReport = ParserFactory.readReport(this.fReportFile, useCache);
        }
        return this.fReport;
    }
}

