/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.set;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.setmatrix.AbstractSetMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.jdbc.autoclose.AutoOpenCloseConnection;
import org.ujmp.jdbc.util.JDBCKeyIterator;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCSetMatrix<V>
extends AbstractSetMatrix<V>
implements Closeable,
Erasable,
Flushable {
    private static final long serialVersionUID = -8233006198283847196L;
    private boolean tableExists;
    private transient Connection connection;
    private transient ResultSet resultSet = null;
    private transient PreparedStatement truncateTableStatement = null;
    private transient PreparedStatement insertStatement = null;
    private transient PreparedStatement deleteStatement = null;
    private transient PreparedStatement containsKeyStatement = null;
    private transient PreparedStatement countStatement = null;
    private transient PreparedStatement selectAllStatement = null;
    private transient PreparedStatement dropTableStatement = null;

    public static <V> JDBCSetMatrix<V> connectToDerby() throws SQLException, IOException {
        return new JDBCSetMatrix<V>("jdbc:derby:" + new File(System.getProperty("java.io.tmpdir") + File.separator + "ujmp" + System.nanoTime() + "derby.temp"), null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToDerby(File folderName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:derby:" + folderName.getAbsolutePath() + "/", null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToDerby(File folderName, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:derby:" + folderName.getAbsolutePath() + "/", null, null, tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToH2() throws SQLException, IOException {
        return new JDBCSetMatrix<V>("jdbc:h2:" + File.createTempFile("ujmp", "h2.temp"), null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToH2(File file) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:h2:" + file.getAbsolutePath(), null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToH2(File file, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:h2:" + file.getAbsolutePath(), null, null, tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToSQLite() throws SQLException, IOException {
        return new JDBCSetMatrix<V>("jdbc:sqlite:" + File.createTempFile("ujmp", "sqlite.temp"), null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToSQLite(File file) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:sqlite:" + file.getAbsolutePath(), null, null, null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToSQLite(File file, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:sqlite:" + file.getAbsolutePath(), null, null, tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToMySQL(String serverName, int port, String username, String password, String databaseName, String tableName, String columnName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName, username, password, tableName, columnName);
    }

    public static <V> JDBCSetMatrix<V> connectToMySQL(String serverName, int port, String userName, String password, String databaseName, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName, userName, password, tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToHSQLDB() throws SQLException, IOException {
        return new JDBCSetMatrix<V>("jdbc:hsqldb:file:/" + File.createTempFile("hsqldb-stringset", ".temp"), "SA", "", null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToHSQLDB(File fileName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:hsqldb:file:/" + fileName.getAbsolutePath(), "SA", "", null, null);
    }

    public static <V> JDBCSetMatrix<V> connectToHSQLDB(File fileName, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:hsqldb:file:/" + fileName.getAbsolutePath(), "SA", "", tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToHSQLDB(File fileName, String userName, String password, String tableName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:hsqldb:file:/" + fileName.getAbsolutePath(), userName, password, tableName, null);
    }

    public static <V> JDBCSetMatrix<V> connectToHSQLDB(File fileName, String userName, String password, String tableName, String columnName) throws SQLException {
        return new JDBCSetMatrix<V>("jdbc:hsqldb:file:/" + fileName.getAbsolutePath(), userName, password, tableName, columnName);
    }

    private JDBCSetMatrix(String url, String username, String password, String tableName, String columnName) throws SQLException {
        this(new AutoOpenCloseConnection(url, username, password), tableName, columnName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JDBCSetMatrix(Connection connection, String tableName, String columnName) throws SQLException {
        this.connection = connection;
        String url = connection.getMetaData().getURL();
        this.setMetaData("URL", url);
        this.setMetaData("SQLDialect", (Object)SQLUtil.getSQLDialect(url));
        this.setMetaData("DatabaseName", SQLUtil.getDatabaseName(url));
        this.setMetaData("TableName", tableName == null ? "ujmp_set_" + UUID.randomUUID() : tableName);
        this.setLabel(this.getTableName());
        this.tableExists = SQLUtil.tableExists(connection, this.getTableName());
        if (!this.tableExists) {
            if (columnName == null || columnName.isEmpty()) {
                this.setMetaData("KeyColumnName", "id");
                this.setColumnLabel(0L, "id");
            } else {
                this.setMetaData("KeyColumnName", columnName);
                this.setColumnLabel(0L, columnName);
            }
            this.createTable(this.getTableName(), this.getKeyColumnName());
            return;
        } else if (columnName == null || columnName.isEmpty()) {
            List<String> keyColumnNames = SQLUtil.getPrimaryKeyColumnNames(connection, this.getTableName());
            if (keyColumnNames.size() != 1) throw new RuntimeException("cannot determine id column");
            this.setMetaData("KeyColumnName", keyColumnNames.get(0));
            this.setColumnLabel(0L, keyColumnNames.get(0));
            return;
        } else {
            this.setMetaData("KeyColumnName", columnName);
            this.setColumnLabel(0L, columnName);
        }
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final String getURL() {
        return this.getMetaDataString("URL");
    }

    public final String getTableName() {
        return this.getMetaDataString("TableName");
    }

    public final String getDatabaseName() {
        return this.getMetaDataString("DatabaseName");
    }

    public final Class<?> getKeyClass() {
        return (Class)this.getMetaData("KeyClass");
    }

    public final String getKeyColumnName() {
        return this.getMetaDataString("KeyColumnName");
    }

    public final SQLUtil.SQLDialect getSQLDialect() {
        Object sqlDialect = this.getMetaData("SQLDialect");
        if (sqlDialect instanceof SQLUtil.SQLDialect) {
            return (SQLUtil.SQLDialect)((Object)this.getMetaData("SQLDialect"));
        }
        return null;
    }

    @Override
    protected final synchronized void clearSet() {
        if (!this.tableExists) {
            return;
        }
        try {
            if (this.truncateTableStatement == null || this.truncateTableStatement.isClosed()) {
                this.truncateTableStatement = SQLUtil.getTruncateTableStatement(this.connection, this.getSQLDialect(), this.getTableName());
                if (this.resultSet != null && !this.resultSet.isClosed()) {
                    this.resultSet.close();
                }
                this.truncateTableStatement.executeUpdate();
                this.truncateTableStatement.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final synchronized boolean removeFromSet(Object key) {
        if (key == null) {
            throw new RuntimeException("object cannot be null");
        }
        if (!this.tableExists) {
            return false;
        }
        try {
            if (this.deleteStatement == null || this.deleteStatement.isClosed()) {
                this.deleteStatement = SQLUtil.getDeleteIdStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
            }
            this.deleteStatement.setObject(1, key);
            return this.deleteStatement.executeUpdate() > 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        try {
            if (this.connection == null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public final synchronized void erase() throws IOException {
        if (!this.tableExists) {
            return;
        }
        try {
            if (this.dropTableStatement == null || this.dropTableStatement.isClosed()) {
                this.dropTableStatement = SQLUtil.getDropTableStatement(this.connection, this.getSQLDialect(), this.getTableName());
                this.dropTableStatement.executeUpdate();
                this.dropTableStatement.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected synchronized boolean addToSet(V o) {
        if (o == null) {
            throw new RuntimeException("object cannot be null");
        }
        if (this.getKeyClass() == null) {
            this.setMetaData("KeyClass", o.getClass());
        }
        try {
            if (!this.contains(o)) {
                if (this.insertStatement == null || this.insertStatement.isClosed()) {
                    this.insertStatement = SQLUtil.getInsertIdStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
                }
                this.insertStatement.setObject(1, o);
                this.insertStatement.executeUpdate();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean contains(Object o) {
        if (o == null) {
            throw new RuntimeException("object cannot be null");
        }
        if (!this.tableExists) {
            return false;
        }
        try {
            if (this.containsKeyStatement == null || this.containsKeyStatement.isClosed()) {
                this.containsKeyStatement = SQLUtil.getExistsStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
            }
            this.containsKeyStatement.setObject(1, o);
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.containsKeyStatement.executeQuery();
            boolean found = false;
            if (this.resultSet.next()) {
                found = MathUtil.getBoolean(this.resultSet.getObject(1));
            }
            this.resultSet.close();
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void beforeWriteObject(ObjectOutputStream os) throws IOException {
        try {
            os.writeObject((Object)this.getSQLDialect());
            os.writeUTF(this.getDatabaseName());
            os.writeUTF(this.getTableName());
            os.writeUTF(this.getKeyColumnName());
            os.writeUTF(this.connection.getMetaData().getURL());
            if (this.connection.getMetaData().getUserName() != null) {
                os.writeBoolean(true);
                os.writeUTF(this.connection.getMetaData().getUserName());
            } else {
                os.writeBoolean(false);
            }
            if (this.connection.getClientInfo("Password") != null) {
                os.writeBoolean(true);
                os.writeUTF(this.connection.getClientInfo("Password"));
            } else {
                os.writeBoolean(false);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void beforeReadObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.setMetaData("SQLDialect", (Object)((SQLUtil.SQLDialect)((Object)is.readObject())));
        this.setMetaData("DatabaseName", is.readUTF());
        this.setMetaData("TableName", is.readUTF());
        this.setMetaData("KeyColumnName", is.readUTF());
        String url = is.readUTF();
        this.setMetaData("URL", url);
        boolean containsUsername = is.readBoolean();
        String username = null;
        if (containsUsername) {
            username = is.readUTF();
        }
        boolean containsPassword = is.readBoolean();
        String password = null;
        if (containsPassword) {
            password = is.readUTF();
        }
        this.connection = new AutoOpenCloseConnection(url, username, password);
    }

    @Override
    public synchronized void flush() throws IOException {
        try {
            switch (this.getSQLDialect()) {
                case H2: {
                    break;
                }
                case HSQLDB: {
                    break;
                }
            }
            this.getConnection().commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final synchronized void createTable(String tableName, String columnName) throws SQLException {
        SQLUtil.createKeyStringTable(this.getConnection(), this.getSQLDialect(), tableName, columnName);
        this.tableExists = true;
    }

    @Override
    public final synchronized int size() {
        try {
            if (!this.tableExists) {
                return 0;
            }
            if (this.countStatement == null || this.countStatement.isClosed()) {
                this.countStatement = SQLUtil.getCountStatement(this.connection, this.getSQLDialect(), this.getTableName());
            }
            ResultSet rs = this.countStatement.executeQuery();
            int size = -1;
            if (!rs.next()) {
                throw new RuntimeException("cannot count entries");
            }
            size = rs.getInt(1);
            rs.close();
            return size;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized Iterator<V> iterator() {
        if (!this.tableExists) {
            return Collections.emptyIterator();
        }
        try {
            if (this.selectAllStatement == null || this.selectAllStatement.isClosed()) {
                this.selectAllStatement = SQLUtil.getSelectIdsStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
            }
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.selectAllStatement.executeQuery();
            return new JDBCKeyIterator(this.resultSet, this.getKeyClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

