/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.stub;

import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.objectmatrix.impl.DefaultDenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapToTiledMatrix2DWrapper
extends AbstractDenseObjectMatrix2D
implements ObjectMatrix2D,
Wrapper<Map<Coordinates, ObjectMatrix2D>> {
    private static final long serialVersionUID = -7464578359102479614L;
    private final int[] tileSize = new int[]{50, 50};
    private final Map<Coordinates, ObjectMatrix2D> values;

    public AbstractMapToTiledMatrix2DWrapper(Map<Coordinates, ObjectMatrix2D> map, long rows, long columns) {
        super(rows, columns);
        this.values = map;
    }

    public AbstractMapToTiledMatrix2DWrapper(Map<Coordinates, ObjectMatrix2D> map, Matrix source) {
        this(map, source.getRowCount(), source.getColumnCount());
        for (long[] c : source.availableCoordinates()) {
            this.setObject(source.getAsObject(c), c);
        }
        MapMatrix<String, Object> a = source.getMetaData();
        if (a != null) {
            this.setMetaData(a.clone());
        }
    }

    @Override
    public synchronized Object getObject(int row, int column) {
        return this.getObject((long)row, (long)column);
    }

    public final Map<Coordinates, ObjectMatrix2D> getMap() {
        return this.values;
    }

    @Override
    public synchronized Object getObject(long row, long column) {
        Coordinates c = Coordinates.wrap(row / (long)this.tileSize[0], column / (long)this.tileSize[1]);
        Matrix m = this.getMap().get(c);
        if (m == null) {
            return null;
        }
        return m.getAsObject(row % (long)this.tileSize[0], column % (long)this.tileSize[1]);
    }

    @Override
    public final Map<Coordinates, ObjectMatrix2D> getWrappedObject() {
        return this.getMap();
    }

    public final void setWrappedObject(Map<Coordinates, ObjectMatrix2D> object) {
        throw new RuntimeException("cannot change map");
    }

    @Override
    public final synchronized double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public final synchronized void setAsDouble(double v, long ... coordinates) {
        this.setObject((Object)v, coordinates);
    }

    @Override
    public synchronized void setObject(Object o, int row, int column) {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public synchronized void setObject(Object o, long row, long column) {
        Coordinates c = Coordinates.wrap(row / (long)this.tileSize[0], column / (long)this.tileSize[1]);
        ObjectMatrix2D m = this.getMap().get(c);
        if (m == null) {
            m = new DefaultDenseObjectMatrix2D(this.tileSize[0], this.tileSize[1]);
            this.getMap().put(c, m);
        }
        m.setObject(o, row % (long)this.tileSize[0], column % (long)this.tileSize[1]);
    }

    public final int[] getTileSize() {
        return this.tileSize;
    }
}

