/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBufferList<A>
implements List<A>,
Serializable {
    private static final long serialVersionUID = 7887830184838493458L;
    private int start = -1;
    private int end = -1;
    private Object[] values;

    public RingBufferList() {
        this(10);
    }

    public RingBufferList(int maximumSize) {
        this.values = new Object[maximumSize];
    }

    public int maxSize() {
        return this.values.length;
    }

    @Override
    public boolean add(A a) {
        if (this.end >= 0) {
            ++this.end;
            if (this.end >= this.values.length) {
                this.end = 0;
            }
            if (this.end == this.start) {
                ++this.start;
            }
            if (this.start >= this.values.length) {
                this.start = 0;
            }
        } else {
            this.start = 0;
            this.end = 0;
        }
        this.values[this.end] = a;
        return true;
    }

    @Override
    public int size() {
        if (this.end < 0) {
            return 0;
        }
        return this.end < this.start ? this.values.length : this.end - this.start + 1;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            s.append(this.get(i));
            if (i >= this.size() - 1) continue;
            s.append(", ");
        }
        return s.toString();
    }

    @Override
    public void addFirst(A a) {
        if (this.end >= 0) {
            --this.start;
            if (this.start < 0) {
                this.start = this.values.length - 1;
            }
            if (this.start == this.end) {
                --this.end;
            }
            if (this.end < 0) {
                this.end = this.values.length - 1;
            }
        } else {
            this.start = 0;
            this.end = 0;
        }
        this.values[this.start] = a;
    }

    @Override
    public A get(int index) {
        return (A)this.values[(this.start + index) % this.values.length];
    }

    @Override
    public A set(int index, A a) {
        Object old = this.values[(this.start + index) % this.values.length];
        this.values[(this.start + index) % this.values.length] = a;
        return (A)old;
    }

    @Override
    public void clear() {
        this.start = -1;
        this.end = -1;
    }

    @Override
    public void add(int index, A element) {
        new Exception("not implemented").printStackTrace();
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        for (A a : c) {
            this.add(a);
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        new Exception("not implemented").printStackTrace();
        return false;
    }

    @Override
    public boolean contains(Object o) {
        int i = this.size();
        while (--i >= 0) {
            if (!o.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<A> iterator() {
        return new RingBufferIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.size();
        while (--i >= 0) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<A> listIterator() {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public boolean remove(Object o) {
        new Exception("not implemented").printStackTrace();
        return false;
    }

    @Override
    public A remove(int index) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        new Exception("not implemented").printStackTrace();
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        new Exception("not implemented").printStackTrace();
        return false;
    }

    @Override
    public List<A> subList(int fromIndex, int toIndex) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public Object[] toArray() {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RingBufferIterator
    implements Iterator<A> {
        int pos = 0;

        @Override
        public boolean hasNext() {
            return this.pos < RingBufferList.this.size();
        }

        @Override
        public A next() {
            Object a = RingBufferList.this.get(this.pos);
            ++this.pos;
            return a;
        }

        @Override
        public void remove() {
            new Exception("not implemented").printStackTrace();
        }
    }
}

