/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.DivideScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DivideScalarSparseMatrix
implements DivideScalarCalculation<SparseMatrix, SparseMatrix> {
    DivideScalarSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source, BigDecimal divisor, SparseMatrix target) {
        MapMatrix<String, Object> a;
        VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
        for (long[] c : source.availableCoordinates()) {
            BigDecimal value = source.getAsBigDecimal(c);
            BigDecimal result = MathUtil.divide(value, divisor);
            target.setAsBigDecimal(result, c);
        }
        if (source != target && (a = source.getMetaData()) != null) {
            target.setMetaData(a.clone());
        }
    }

    @Override
    public final void calc(SparseMatrix source, double divisor, SparseMatrix target) {
        this.calc(source, new BigDecimal(divisor, UJMPSettings.getInstance().getMathContext()), target);
    }
}

