/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.calculation;

import java.math.BigInteger;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigintegermatrix.BigIntegerMatrix;
import org.ujmp.core.bigintegermatrix.calculation.BigIntegerCalculation;
import org.ujmp.core.bigintegermatrix.impl.BigIntegerCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;

public abstract class AbstractBigIntegerCalculation
extends AbstractCalculation
implements BigIntegerCalculation {
    private static final long serialVersionUID = 6820193205334660103L;

    public AbstractBigIntegerCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractBigIntegerCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final BigIntegerMatrix calcNew() {
        BigIntegerMatrix result = (BigIntegerMatrix)Matrix.Factory.zeros(ValueType.BIGINTEGER, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsBigInteger(this.getBigInteger(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public final BigIntegerMatrix calcLink() {
        return new BigIntegerCalculationMatrix(this);
    }

    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsBigInteger(this.getBigInteger(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setBigInteger(BigInteger value, long ... coordinates) {
    }

    public final ValueType getValueType() {
        return ValueType.BIGINTEGER;
    }
}

