/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VMSFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: VMSFileParser.java,v 1.9 2011-05-03 01:49:00 bruceb Exp $";
    private static Logger log = Logger.getLogger("VMSFileParser");
    private static final String DIR = ".DIR";
    private static final String HDR = "Directory";
    private static final String TOTAL = "Total";
    private static final int DEFAULT_BLOCKSIZE = 524288;
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;
    private SimpleDateFormat formatter1;
    private SimpleDateFormat formatter2;
    private boolean versionInName = false;
    private int blocksize = 524288;

    public VMSFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public boolean isMultiLine() {
        return true;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public void setBlocksize(int blocksize) {
        this.blocksize = blocksize;
    }

    public boolean isVersionInName() {
        return this.versionInName;
    }

    public void setVersionInName(boolean versionInName) {
        this.versionInName = versionInName;
    }

    public String toString() {
        return "VMS";
    }

    public boolean isValidFormat(String[] listing) {
        int count = Math.min(listing.length, 10);
        boolean semiColonName = false;
        boolean squareBracketStart = false;
        boolean squareBracketEnd = false;
        for (int i = 0; i < count; ++i) {
            if (listing[i].trim().length() == 0) continue;
            int pos = 0;
            pos = listing[i].indexOf(59);
            if (pos > 0 && ++pos < listing[i].length() && Character.isDigit(listing[i].charAt(pos))) {
                semiColonName = true;
            }
            if (listing[i].indexOf(91) > 0) {
                squareBracketStart = true;
            }
            if (listing[i].indexOf(93) <= 0) continue;
            squareBracketEnd = true;
        }
        if (semiColonName && squareBracketStart && squareBracketEnd) {
            return true;
        }
        log.debug("Not in VMS format");
        return false;
    }

    public FTPFile parse(String raw) throws ParseException {
        Date lastModified;
        long size;
        boolean isDir;
        String name;
        String[] fields;
        block18: {
            fields = this.split(raw);
            if (fields.length <= 0) {
                return null;
            }
            if (fields.length >= 2 && fields[0].compareTo(HDR) == 0) {
                return null;
            }
            if (fields.length > 0 && fields[0].compareTo(TOTAL) == 0) {
                return null;
            }
            if (fields.length < 4) {
                return null;
            }
            name = fields[0];
            int semiPos = name.lastIndexOf(59);
            if (semiPos <= 0) {
                log.warn("File version number not found in name '" + name + "'");
                return null;
            }
            String nameNoVersion = name.substring(0, semiPos);
            String afterSemi = name.substring(semiPos + 1);
            try {
                Integer.parseInt(afterSemi);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            isDir = false;
            if (nameNoVersion.endsWith(DIR)) {
                isDir = true;
                name = nameNoVersion.substring(0, nameNoVersion.length() - DIR.length());
            }
            if (!this.versionInName && !isDir) {
                name = nameNoVersion;
            }
            int slashPos = fields[1].indexOf(47);
            String sizeUsed = fields[1];
            if (slashPos > 0) {
                sizeUsed = fields[1].substring(0, slashPos);
            }
            size = Long.parseLong(sizeUsed) * (long)this.blocksize;
            lastModified = null;
            try {
                lastModified = this.formatter1.parse(fields[2] + " " + fields[3]);
            }
            catch (ParseException ex) {
                try {
                    lastModified = this.formatter2.parse(fields[2] + " " + fields[3]);
                }
                catch (ParseException ex1) {
                    if (this.ignoreDateParseErrors) break block18;
                    throw new DateParseException(ex.getMessage());
                }
            }
        }
        String group = null;
        String owner = null;
        if (fields.length >= 5 && fields[4].charAt(0) == '[' && fields[4].charAt(fields[4].length() - 1) == ']') {
            int commaPos = fields[4].indexOf(44);
            if (commaPos < 0) {
                group = owner = fields[4];
            } else {
                group = fields[4].substring(1, commaPos);
                owner = fields[4].substring(commaPos + 1, fields[4].length() - 1);
            }
        }
        String permissions = null;
        if (fields.length >= 6 && fields[5].charAt(0) == '(' && fields[5].charAt(fields[5].length() - 1) == ')') {
            permissions = fields[5].substring(1, fields[5].length() - 2);
        }
        FTPFile file = new FTPFile(raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setPermissions(permissions);
        return file;
    }

    public void setLocale(Locale locale) {
        this.formatter1 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", locale);
        this.formatter2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm", locale);
    }
}

