/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ujmp.core.graphmatrix.GraphMatrix;
import org.ujmp.jung.EdgeWrapper;
import org.ujmp.jung.EdgeWrapperCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMatrixWrapper<V, E>
extends AbstractTypedGraph<V, EdgeWrapper<E>>
implements DirectedGraph<V, EdgeWrapper<E>> {
    private static final long serialVersionUID = -3871581250021217530L;
    private final GraphMatrix<V, E> graphMatrix;

    public GraphMatrixWrapper(GraphMatrix<V, E> graphMatrix) {
        super(EdgeType.DIRECTED);
        this.graphMatrix = graphMatrix;
    }

    public Collection<EdgeWrapper<E>> getInEdges(V vertex) {
        long childIndex = this.graphMatrix.getIndexOfNode(vertex);
        List<Long> parentIndices = this.graphMatrix.getParentIndices(vertex);
        ArrayList<EdgeWrapper<EdgeWrapper<E>>> edges = new ArrayList<EdgeWrapper<EdgeWrapper<E>>>();
        for (long parentIndex : parentIndices) {
            E edge = this.graphMatrix.getEdge((V)parentIndex, (V)childIndex);
            EdgeWrapper<E> edgeWrapper = new EdgeWrapper<E>(parentIndex, childIndex, edge);
            edges.add(edgeWrapper);
        }
        return edges;
    }

    public Collection<EdgeWrapper<E>> getOutEdges(V vertex) {
        long parentIndex = this.graphMatrix.getIndexOfNode(vertex);
        List<Long> childIndices = this.graphMatrix.getChildIndices(vertex);
        ArrayList<EdgeWrapper<EdgeWrapper<E>>> edges = new ArrayList<EdgeWrapper<EdgeWrapper<E>>>();
        for (long childIndex : childIndices) {
            E edge = this.graphMatrix.getEdge((V)parentIndex, (V)childIndex);
            EdgeWrapper<E> edgeWrapper = new EdgeWrapper<E>(parentIndex, childIndex, edge);
            edges.add(edgeWrapper);
        }
        return edges;
    }

    public Collection<V> getPredecessors(V vertex) {
        return this.graphMatrix.getParents(vertex);
    }

    public Collection<V> getSuccessors(V vertex) {
        return this.graphMatrix.getChildren(vertex);
    }

    public V getSource(EdgeWrapper<E> directed_edge) {
        return this.graphMatrix.getNode(directed_edge.getCoordinates().getLongCoordinates()[0]);
    }

    public V getDest(EdgeWrapper<E> directed_edge) {
        return this.graphMatrix.getNode(directed_edge.getCoordinates().getLongCoordinates()[1]);
    }

    public boolean isSource(V vertex, EdgeWrapper<E> edge) {
        V source = this.getSource(edge);
        return vertex == source;
    }

    public boolean isDest(V vertex, EdgeWrapper<E> edge) {
        V dest = this.getDest(edge);
        return vertex == dest;
    }

    public Pair<V> getEndpoints(EdgeWrapper<E> edge) {
        long[] c = edge.getCoordinates().getLongCoordinates();
        return new Pair(this.graphMatrix.getNode(c[0]), this.graphMatrix.getNode(c[1]));
    }

    public Collection<EdgeWrapper<E>> getEdges() {
        return new EdgeWrapperCollection<E>(this.graphMatrix);
    }

    public Collection<V> getVertices() {
        return this.graphMatrix.getNodeList();
    }

    public boolean containsVertex(V vertex) {
        return this.graphMatrix.getNodeList().contains(vertex);
    }

    public boolean containsEdge(EdgeWrapper<E> edge) {
        for (EdgeWrapper<E> edgeWrapper : this.getEdges()) {
            if (!edgeWrapper.equals(edge)) continue;
            return true;
        }
        return false;
    }

    public int getEdgeCount() {
        return this.graphMatrix.getEdgeCount();
    }

    public int getVertexCount() {
        return this.graphMatrix.getNodeCount();
    }

    public Collection<V> getNeighbors(V vertex) {
        ArrayList<V> neighbors = new ArrayList<V>();
        neighbors.addAll(this.graphMatrix.getParents(vertex));
        neighbors.addAll(this.graphMatrix.getChildren(vertex));
        return neighbors;
    }

    public Collection<EdgeWrapper<E>> getIncidentEdges(V vertex) {
        ArrayList<EdgeWrapper<EdgeWrapper<E>>> edges = new ArrayList<EdgeWrapper<EdgeWrapper<E>>>();
        edges.addAll(this.getInEdges(vertex));
        edges.addAll(this.getOutEdges(vertex));
        return edges;
    }

    public boolean addVertex(V vertex) {
        this.graphMatrix.addNode(vertex);
        return true;
    }

    public boolean removeVertex(V vertex) {
        this.graphMatrix.removeNode(vertex);
        return true;
    }

    public boolean removeEdge(EdgeWrapper<E> edge) {
        long[] coordinates = edge.getCoordinates().getLongCoordinates();
        this.graphMatrix.removeEdge(coordinates[0], coordinates[1]);
        return true;
    }

    public boolean addEdge(EdgeWrapper<E> edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        this.graphMatrix.setEdge(edge.getEdge(), endpoints.getFirst(), endpoints.getSecond());
        if (edgeType == EdgeType.UNDIRECTED) {
            this.graphMatrix.setEdge(edge.getEdge(), endpoints.getSecond(), endpoints.getFirst());
        }
        return true;
    }

    public GraphMatrix<V, E> getGraphMatrix() {
        return this.graphMatrix;
    }
}

