/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.reports.EnrichmentReports;
import gnu.trove.TFloatIntHashMap;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TIntIntHashMap;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.genepattern.gsea.HistogramDataset;
import org.genepattern.uiutil.UIUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class JaccardHistogram
extends JPanel {
    private double binWidth = 0.02;
    private JFreeChart jaccardChart;
    private TFloatIntHashMap jaccardToOccurrencesMap;
    private ChartPanel chartPanel;

    public JaccardHistogram() {
        this.setLayout(new BorderLayout());
        this.jaccardChart = ChartFactory.createHistogram((String)"", (String)"Jaccard", (String)"Number of Occurences", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chartPanel = new ChartPanel(this.jaccardChart, false, false, false, false, false);
        XYPlot plot = this.jaccardChart.getXYPlot();
        plot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot.getRangeAxis().setTickMarkPaint((Paint)Color.GRAY);
        plot.getRangeAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
        plot.getDomainAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getDomainAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot.getDomainAxis().setTickMarkPaint((Paint)Color.GRAY);
        plot.getDomainAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        ((NumberAxis)plot.getDomainAxis()).setAutoRangeIncludesZero(true);
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setGradientPaintTransformer(null);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setSeriesOutlinePaint(0, (Paint)Color.GRAY);
        this.chartPanel.setMouseZoomable(true, false);
        this.chartPanel.getChart().setBackgroundPaint((Paint)EnrichmentReports.CHART_FRAME_COLOR);
        this.add((Component)this.chartPanel);
        JLabel binWidthLabel = new JLabel("Bin Width:");
        final JTextField binWidthTextField = new JTextField("" + this.binWidth, 4);
        JButton btn = new JButton("Update");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double d = Double.parseDouble(binWidthTextField.getText().trim());
                    if (d < 0.0 || d > 1.0) {
                        UIUtil.showMessageDialog(JaccardHistogram.this.chartPanel.getTopLevelAncestor(), "Bin width must be between zero and one.");
                        return;
                    }
                    JaccardHistogram.this.binWidth = d;
                }
                catch (NumberFormatException e1) {
                    UIUtil.showMessageDialog(JaccardHistogram.this.chartPanel.getTopLevelAncestor(), "Bin width is not a number.");
                    return;
                }
                JaccardHistogram.this.updateJaccardHistogram();
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(binWidthLabel);
        bottomPanel.add(binWidthTextField);
        bottomPanel.add(btn);
        this.add((Component)bottomPanel, "South");
    }

    void updateJaccardHistogram() {
        if (this.binWidth != 0.0) {
            int occurences;
            TIntIntHashMap binNumberToOccurencesMap = new TIntIntHashMap();
            XYSeries series = new XYSeries((Comparable)((Object)""));
            HistogramDataset coll = new HistogramDataset(this.binWidth);
            coll.setIntervalWidth(0.0);
            coll.addSeries(series);
            TFloatIntIterator it = this.jaccardToOccurrencesMap.iterator();
            while (it.hasNext()) {
                it.advance();
                float value = it.key();
                occurences = it.value();
                int bin = (int)((double)value / this.binWidth);
                int priorOccurences = binNumberToOccurencesMap.get(bin);
                binNumberToOccurencesMap.put(bin, occurences + priorOccurences);
            }
            it = binNumberToOccurencesMap.iterator();
            while (it.hasNext()) {
                it.advance();
                int binNumber = it.key();
                occurences = it.value();
                double valueForBin = (double)binNumber * this.binWidth;
                series.add(valueForBin, (double)occurences);
            }
            this.jaccardChart.getXYPlot().setDataset((XYDataset)coll);
        }
    }

    public void setJaccardToOccurrencesMap(TFloatIntHashMap jaccardToOccurrencesMap) {
        this.jaccardToOccurrencesMap = jaccardToOccurrencesMap;
        this.updateJaccardHistogram();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

