/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.JideBoxLayout;
import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.TraceUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import xtools.api.param.MissingReqdParamException;

public class ErrorWidgetJide2
extends StandardDialog {
    private JComponent _detailsPanel;
    private Throwable[] fErrors;
    private String fError_msg;

    public ErrorWidgetJide2(Frame parent, String title, Throwable t_opt, String error_msg_opt) throws HeadlessException {
        super(parent, ErrorWidgetJide2._title(title));
        Throwable[] tss = null;
        if (t_opt != null) {
            tss = new Throwable[]{t_opt};
        }
        this.init(title, tss, error_msg_opt);
    }

    public ErrorWidgetJide2(Frame parent, Errors errors) throws HeadlessException {
        super(parent, ErrorWidgetJide2._title(errors.getName()));
        this.init(errors.getName(), errors.getErrors(), errors.getErrors(false));
    }

    public ErrorWidgetJide2(Frame parent, String errMsg) throws HeadlessException {
        super(parent, ErrorWidgetJide2._title(errMsg));
        this.init(errMsg, null, errMsg);
    }

    private static String _title(String title) {
        if (title != null && title.length() > 80) {
            return "Error: " + title.substring(0, 80);
        }
        if (title != null) {
            return "Error: " + title;
        }
        return "Error";
    }

    private void init(String title, Throwable[] t_opt, String error_msg_opt) {
        boolean dontTruncate = false;
        if (error_msg_opt == null && t_opt != null && t_opt.length > 0 && t_opt[0] != null) {
            error_msg_opt = t_opt[0].getMessage();
            Throwable t = t_opt[0];
            Throwable tc = t.getCause();
            if (t instanceof MissingReqdParamException) {
                error_msg_opt = ((MissingReqdParamException)t).getMessageLongInHtml();
                dontTruncate = true;
            } else if (tc instanceof MissingReqdParamException) {
                error_msg_opt = ((MissingReqdParamException)tc).getMessageLongInHtml();
                dontTruncate = true;
            }
        }
        this.fError_msg = error_msg_opt != null && error_msg_opt.length() > 80 && !dontTruncate ? error_msg_opt.substring(0, 80) + " ..." : error_msg_opt;
        this.fErrors = t_opt;
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createDetailsPanel() {
        final JTextArea textArea = new JTextArea();
        textArea.setColumns(80);
        textArea.setRows(20);
        textArea.setCaretPosition(0);
        StringBuffer buf = new StringBuffer("<Error Details>\n\n");
        buf.append("---- Full Error Message ----\n");
        if (this.fError_msg != null) {
            buf.append(this.fError_msg);
        } else {
            buf.append("na");
        }
        buf.append("\n\n");
        buf.append("---- Stack Trace ----\n");
        buf.append(TraceUtils.getAsString(this.fErrors));
        JLabel label = new JLabel("Details:");
        textArea.setText(buf.toString());
        textArea.setEditable(false);
        JPanel butPanel = new JPanel(new FlowLayout(2));
        JButton bCopy = new JButton("Copy");
        butPanel.add(bCopy);
        bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(textArea.getText());
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)new JScrollPane(textArea), "Center");
        panel.add((Component)butPanel, "South");
        panel.add((Component)label, "First");
        label.setLabelFor(textArea);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return panel;
    }

    protected StandardDialogPane createStandardDialogPane() {
        return new StandardDialog.DefaultStandardDialogPane(){

            protected void layoutComponents(Component bannerPanel, Component contentPanel, ButtonPanel buttonPanel) {
                this.setLayout((LayoutManager)new JideBoxLayout((Container)((Object)this), 1));
                if (bannerPanel != null) {
                    this.add(bannerPanel);
                }
                if (contentPanel != null) {
                    this.add(contentPanel);
                }
                this.add((Component)buttonPanel, "fix");
                ErrorWidgetJide2.this._detailsPanel = ErrorWidgetJide2.this.createDetailsPanel();
                this.add(ErrorWidgetJide2.this._detailsPanel, "vary");
                ErrorWidgetJide2.this._detailsPanel.setVisible(false);
            }
        };
    }

    public JComponent createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 40, 40, 40));
        JLabel label = this.fError_msg != null ? new JLabel(this.fError_msg) : new JLabel("There was an error. Click the details button for more information.");
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        return panel;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton closeButton = new JButton();
        JButton detailButton = new JButton();
        detailButton.setMnemonic('D');
        closeButton.setName("OK");
        buttonPanel.addButton((AbstractButton)closeButton, (Object)"AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)detailButton, (Object)"ALTERNATIVE");
        closeButton.setAction(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorWidgetJide2.this.setDialogResult(0);
                ErrorWidgetJide2.this.setVisible(false);
                ErrorWidgetJide2.this.dispose();
            }
        });
        if (this.fErrors != null) {
            Action help_action = null;
            for (int i = 0; i < this.fErrors.length; ++i) {
                if (!(this.fErrors[i] instanceof StandardException)) continue;
                help_action = JarResources.createHelpAction((StandardException)this.fErrors[i]);
            }
            if (help_action != null) {
                JButton helpButton = new JButton("Help");
                helpButton.setAction(help_action);
                buttonPanel.addButton((AbstractButton)helpButton, (Object)"HELP");
            }
        }
        detailButton.setAction(new AbstractAction("Details >>"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErrorWidgetJide2.this._detailsPanel.isVisible()) {
                    ErrorWidgetJide2.this._detailsPanel.setVisible(false);
                    this.putValue("Name", "Details <<");
                    ErrorWidgetJide2.this.pack();
                } else {
                    ErrorWidgetJide2.this._detailsPanel.setVisible(true);
                    this.putValue("Name", "<< Details");
                    ErrorWidgetJide2.this.pack();
                }
            }
        });
        this.setDefaultCancelAction(closeButton.getAction());
        this.setDefaultAction(closeButton.getAction());
        this.getRootPane().setDefaultButton(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }
}

