/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import edu.mit.broad.genome.parsers.AuxUtils;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelledVector
extends AbstractObject {
    private List<String> fLabels;
    private Vector fVector;
    private TObjectIntHashMap fLabelNameLabelIndexMap;
    private MetricWeightStruc ws;

    public LabelledVector(RankedList rl) {
        this.init(rl.getName(), rl.getRankedNames(), rl.getScoresV(true));
    }

    public LabelledVector(String name, String[] labels, float[] floats) {
        this.init(name, labels, new Vector(floats));
    }

    public LabelledVector(String name, String[] labels, Vector floats) {
        this.init(name, labels, floats);
    }

    public LabelledVector(String name, List<String> labels, Vector v) {
        this.init(name, labels, v);
    }

    public LabelledVector(List<String> labels, Vector v) {
        this.init(labels, v);
    }

    public LabelledVector(String[] labels, Vector v) {
        this.init(labels, v);
    }

    public LabelledVector(String labelPrefix, Vector v) {
        if (v == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (labelPrefix == null) {
            labelPrefix = "";
        }
        String[] labels = new String[v.getSize()];
        for (int i = 0; i < v.getSize(); ++i) {
            labels[i] = labelPrefix + i;
        }
        this.init(labels, v);
    }

    private void init(String[] alabels, Vector v) {
        this.init(null, alabels, v);
    }

    private void init(String name, String[] alabels, Vector v) {
        if (v == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (alabels == null) {
            throw new IllegalArgumentException("Param alabels cannot be null");
        }
        if (v.getSize() != alabels.length) {
            throw new MismatchedSizeException("Vector", v.getSize(), "Labels", alabels.length);
        }
        ArrayList<String> labels = new ArrayList<String>(alabels.length);
        for (int i = 0; i < alabels.length; ++i) {
            labels.add(alabels[i]);
        }
        this.init(name, labels, v);
    }

    private void init(List<String> labels, Vector v) {
        this.init(null, labels, v);
    }

    private void init(String name, List<String> labels, Vector v) {
        if (v == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (labels == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (v.getSize() != labels.size()) {
            throw new MismatchedSizeException("Vector", v.getSize(), "Labels", labels.size());
        }
        if (name == null) {
            super.initialize(" " + this.getClass().hashCode() + System.currentTimeMillis());
        } else {
            super.initialize(name);
        }
        this.fVector = v;
        this.fLabels = labels;
        this.fVector.setImmutable();
    }

    @Override
    public String getQuickInfo() {
        return Integer.toString(this.fLabels.size()) + " labels";
    }

    public float getScore(String label) {
        int elemIndex = this._labelIndex(label);
        if (elemIndex == -1) {
            System.err.println("Labels are: \n" + this.getLabels() + "\n");
            throw new IllegalArgumentException("No match to label: " + label);
        }
        return this.fVector.getElement(elemIndex);
    }

    public float getScore(int i) {
        return this.fVector.getElement(i);
    }

    public String getLabel(int i) {
        return this.fLabels.get(i);
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.fLabels);
    }

    public RankedList sort(SortMode sort, Order order) {
        DoubleElement[] dels = this.toDoubleElements();
        dels = DoubleElement.sort(sort, order, dels);
        ArrayList<String> labels = new ArrayList<String>(dels.length);
        Vector v = new Vector(dels.length);
        for (int i = 0; i < dels.length; ++i) {
            labels.add(this.getLabel(dels[i].fIndex));
            v.setElement(i, (float)dels[i].fValue);
        }
        return new DefaultRankedList(this.getName(), labels, v);
    }

    private int _labelIndex(String label) {
        if (this.fLabelNameLabelIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if (this.fLabelNameLabelIndexMap.containsKey((Object)label)) {
            return this.fLabelNameLabelIndexMap.get((Object)label);
        }
        String al = AuxUtils.getAuxNameOnlyNoHash(label);
        if (this.fLabelNameLabelIndexMap.containsKey((Object)al)) {
            return this.fLabelNameLabelIndexMap.get((Object)al);
        }
        return -1;
    }

    private void cacheRowNameIndex() {
        if (this.fLabelNameLabelIndexMap == null) {
            this.fLabelNameLabelIndexMap = new TObjectIntHashMap();
            for (int rown = 0; rown < this.getSize(); ++rown) {
                this.fLabelNameLabelIndexMap.put((Object)this.getLabel(rown), rown);
            }
        }
    }

    public Vector getScoresV(boolean clonedCopy) {
        if (clonedCopy) {
            return new Vector(this.fVector, false);
        }
        this.fVector.setImmutable();
        return this.fVector;
    }

    public int getSize() {
        return this.fVector.getSize();
    }

    public DoubleElement[] toDoubleElements() {
        DoubleElement[] dels = new DoubleElement[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            dels[i] = new DoubleElement(i, this.getScore(i));
        }
        return dels;
    }

    public MetricWeightStruc getMetricWeightStruc() {
        if (this.ws == null) {
            this.ws = new DefaultMetricWeightStruc(null, this);
        }
        return this.ws;
    }
}

