/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables;
import edu.mit.broad.genome.alg.gsea.GeneToGeneSetMap;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.param.BadParamException;

public class GeneSetCohort {
    private Logger log = LoggerFactory.getLogger(GeneSetCohort.class);
    private GeneSet[] fGeneSets;
    private THashSet[] fFastSets;
    private RankedList fRankedList;
    private Map<String, GeneSet> fGeneSetNameGeneSetMap;
    private GeneToGeneSetMap fGeneToGeneSetMap;
    private GeneSetScoringTable[] fGeneSetScoringTables;
    private GeneSetScoringTable fOrigTable;

    private GeneSetCohort(GeneSetScoringTable scoringTable, RankedList rl, GeneSet[] gsets, GeneToGeneSetMap g2gsetmap) {
        if (rl == null) {
            throw new IllegalArgumentException("Parameter rl cannot be null");
        }
        if (gsets == null) {
            throw new IllegalArgumentException("Parameter gsets cannot be null");
        }
        if (gsets.length == 0) {
            this.log.warn("zero length gsets array: {}", (Object)gsets.length);
        }
        this.fOrigTable = scoringTable;
        this.fRankedList = rl;
        this.fGeneSets = new GeneSet[gsets.length];
        this.fFastSets = new THashSet[gsets.length];
        this.fGeneSetNameGeneSetMap = new HashMap<String, GeneSet>();
        boolean atleastonewithits = false;
        for (int g1 = 0; g1 < gsets.length; ++g1) {
            this.fGeneSets[g1] = gsets[g1];
            this.fFastSets[g1] = new THashSet(this.fGeneSets[g1].getMembers());
            this.fGeneSetNameGeneSetMap.put(this.fGeneSets[g1].getName(), this.fGeneSets[g1]);
            if (!atleastonewithits && this.fGeneSets[g1].getNumMembers() > 0) {
                atleastonewithits = true;
            }
            if (g1 < 500 || g1 % 500 != 0) continue;
            System.out.println("GeneSetCohorted: " + (g1 + 1) + " / " + this.fGeneSets.length);
        }
        if (!atleastonewithits) {
            this.log.info("rl: {} \n{}", (Object)rl.getName(), rl.getRankedNames().subList(0, 10));
            TraceUtils.showTrace();
            this.log.warn("No hits in the ranked list to any of the gene sets!");
        }
        this.fGeneToGeneSetMap = g2gsetmap == null ? GeneToGeneSetMap.generateGeneToGenesetMap(this.fGeneSets) : g2gsetmap;
        this.fGeneSetScoringTables = new GeneSetScoringTable[this.fGeneSets.length];
        for (int g = 0; g < this.fGeneSets.length; ++g) {
            this.fGeneSetScoringTables[g] = scoringTable.createTable(this.fGeneSets[g], rl, this.fOrigTable.getRankedList());
            if (g < 500 || g % 500 != 0) continue;
            System.out.println("GeneSetCohorted_scored: " + (g + 1) + " / " + this.fGeneSets.length);
        }
    }

    public int[] genesetIndicesForGene(String geneName) {
        return this.fGeneToGeneSetMap.getGenesetIndicesForGene(geneName);
    }

    public boolean isMember(int gsetNum, String name) {
        return this.fFastSets[gsetNum].contains((Object)name);
    }

    public int getNumGeneSets() {
        return this.fGeneSets.length;
    }

    public int getNumTrue(int gsetNum) {
        return this.fGeneSets[gsetNum].getNumMembers();
    }

    public int getNumLabels() {
        return this.fRankedList.getSize();
    }

    public RankedList getRankedList() {
        return this.fRankedList;
    }

    public GeneSetCohort clone(GeneSet[] gsets) {
        return new GeneSetCohort(this.fOrigTable, this.getRankedList(), gsets, GeneToGeneSetMap.generateGeneToGenesetMap(gsets));
    }

    public double getHitPoints(int gsetNum, String geneName) {
        return this.fGeneSetScoringTables[gsetNum].getHitScore(geneName);
    }

    public double getMissPoints(int gsetNum, String geneName) {
        return this.fGeneSetScoringTables[gsetNum].getMissScore(geneName);
    }

    public static class Generator {
        private Logger log = LoggerFactory.getLogger(Generator.class);
        private int geneSetMinSize;
        private int geneSetMaxSize;
        private GeneSetScoringTable origTable;

        public Generator(GeneSetScoringTable scoringTable, int geneSetMinSize, int geneSetMaxSize) {
            this.origTable = scoringTable;
            this.geneSetMinSize = geneSetMinSize;
            this.geneSetMaxSize = geneSetMaxSize;
        }

        public GeneSetCohort createGeneSetCohort(RankedList rl, GeneSet[] gsets, boolean realRl) {
            GeneToGeneSetMap g2gsetMap = GeneToGeneSetMap.generateGeneToGenesetMap(gsets);
            if (realRl && this.origTable instanceof GeneSetScoringTables.WeightedDoubleSidedAs) {
                this.log.warn("### SETTING REAL RL: " + rl.getName());
                ((GeneSetScoringTables.WeightedDoubleSidedAs)this.origTable).setReal(rl);
            }
            if (realRl && this.origTable instanceof GeneSetScoringTables.WeightedDoubleSidedAs1) {
                this.log.warn("### SETTING REAL RL: " + rl.getName());
                ((GeneSetScoringTables.WeightedDoubleSidedAs1)this.origTable).setReal(rl);
            }
            return new GeneSetCohort(this.origTable, rl, gsets, g2gsetMap);
        }

        public GeneSet[] filterGeneSetsByMembersAndSize(RankedList rl, GeneSet[] gsets) throws Exception {
            if (this.geneSetMaxSize < this.geneSetMinSize) {
                throw new IllegalArgumentException("Max size cannot be less than min size");
            }
            if (this.geneSetMinSize != this.geneSetMaxSize) {
                this.log.info("Got gsets: " + gsets.length + " now preprocessing them ... min: " + this.geneSetMinSize + " max: " + this.geneSetMaxSize);
                gsets = GeneSetGenerators.removeGeneSetsSmallerThan(gsets, this.geneSetMinSize, rl);
                this.log.info("Done preproc for smaller than: " + this.geneSetMinSize);
                gsets = GeneSetGenerators.removeGeneSetsLargerThan(gsets, this.geneSetMaxSize, rl);
                this.log.info("Done preproc for larger than: " + this.geneSetMaxSize);
            } else {
                this.log.info("Skipped gene set size filtering: max and min thresholds are equal");
            }
            gsets = this.removeAllZeroMemberSets(gsets);
            this.checkForZeroContentGeneSets(gsets);
            this.log.debug("Done geneset preproc starting analysis ...");
            return gsets;
        }

        private GeneSet[] removeAllZeroMemberSets(GeneSet[] gsets) {
            ArrayList<GeneSet> list = new ArrayList<GeneSet>();
            for (int i = 0; i < gsets.length; ++i) {
                if (gsets[i].getNumMembers() <= 0) continue;
                list.add(gsets[i]);
            }
            return list.toArray(new GeneSet[list.size()]);
        }

        private void checkForZeroContentGeneSets(GeneSet[] qual_gsets) {
            if (qual_gsets != null) {
                for (int i = 0; i < qual_gsets.length; ++i) {
                    if (qual_gsets[i].getNumMembers() <= 0) continue;
                    return;
                }
            }
            throw new BadParamException("After pruning, none of the gene sets passed size thresholds.", 1001);
        }
    }
}

