/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.autoclose;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.ujmp.jdbc.autoclose.AutoCloseConnection;
import org.ujmp.jdbc.autoclose.AutoCloseResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCloseStatement
implements Statement {
    private final AutoCloseConnection connection;
    private final Statement statement;

    public AutoCloseStatement(AutoCloseConnection connection, Statement statement) {
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.connection.resetTimer();
        return new AutoCloseResultSet(this.connection, this.statement.executeQuery(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.connection.resetTimer();
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.connection.resetTimer();
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.connection.resetTimer();
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.connection.resetTimer();
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.connection.resetTimer();
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.connection.resetTimer();
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.resetTimer();
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.resetTimer();
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.connection.resetTimer();
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.connection.resetTimer();
        return this.statement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.connection.resetTimer();
        return new AutoCloseResultSet(this.connection, this.statement.getResultSet());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.connection.resetTimer();
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.connection.resetTimer();
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.connection.resetTimer();
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.connection.resetTimer();
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.connection.resetTimer();
        return this.statement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.connection.resetTimer();
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.connection.resetTimer();
        return new AutoCloseResultSet(this.connection, this.statement.getGeneratedKeys());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.connection.resetTimer();
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.connection.resetTimer();
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.connection.resetTimer();
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.connection.resetTimer();
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.connection.resetTimer();
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.connection.resetTimer();
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.connection.resetTimer();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.connection.resetTimer();
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.connection.resetTimer();
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.connection.resetTimer();
        return this.statement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.connection.resetTimer();
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.connection.resetTimer();
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.connection.resetTimer();
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.connection.resetTimer();
        return this.statement.isWrapperFor(iface);
    }

    public String toString() {
        this.connection.resetTimer();
        return this.statement.toString();
    }

    public boolean equals(Object obj) {
        this.connection.resetTimer();
        return this.statement.equals(obj);
    }

    public int hashCode() {
        this.connection.resetTimer();
        return this.statement.hashCode();
    }
}

