/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

public class HypergeometricProbability {
    public final double P12 = Math.PI * 2;
    public final double S0 = 0.08333333333333333;
    public final double S1 = 0.002777777777777778;
    public final double S2 = 7.936507936507937E-4;
    public final double S3 = 5.952380952380953E-4;
    public final double S4 = 8.417508417508417E-4;
    public static double[] sfe = new double[16];

    public HypergeometricProbability() {
        HypergeometricProbability.sfe[0] = 0.0;
        HypergeometricProbability.sfe[1] = 0.08106146679532726;
        HypergeometricProbability.sfe[2] = 0.0413406959554093;
        HypergeometricProbability.sfe[3] = 0.02767792568499834;
        HypergeometricProbability.sfe[4] = 0.020790672103765093;
        HypergeometricProbability.sfe[5] = 0.016644691189821193;
        HypergeometricProbability.sfe[6] = 0.013876128823070748;
        HypergeometricProbability.sfe[7] = 0.01189670994589177;
        HypergeometricProbability.sfe[8] = 0.010411265261972096;
        HypergeometricProbability.sfe[9] = 0.009255462182712733;
        HypergeometricProbability.sfe[10] = 0.00833056343336287;
        HypergeometricProbability.sfe[11] = 0.007573675487951841;
        HypergeometricProbability.sfe[12] = 0.00694284010720953;
        HypergeometricProbability.sfe[13] = 0.006408994188004207;
        HypergeometricProbability.sfe[14] = 0.0059513701127588475;
        HypergeometricProbability.sfe[15] = 0.005554733551962801;
    }

    public double stirlerr(int n) {
        if (n < 16) {
            return sfe[n];
        }
        double d = n;
        d *= d;
        if (n > 500) {
            return (0.08333333333333333 - 0.002777777777777778 / d) / (double)n;
        }
        if (n > 80) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / d) / d) / (double)n;
        }
        if (n > 35) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / d) / d) / d) / (double)n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / d) / d) / d) / d) / (double)n;
    }

    public double bd0(int n, double d) {
        if (Math.abs((double)n - d) < 0.1 * ((double)n + d)) {
            double d2 = ((double)n - d) * ((double)n - d) / ((double)n + d);
            double d3 = ((double)n - d) / ((double)n + d);
            double d4 = (double)(2 * n) * d3;
            d3 *= d3;
            int n2 = 1;
            while (true) {
                double d5;
                if ((d5 = d2 + (d4 *= d3) / (double)((n2 << 1) + 1)) == d2) {
                    return d5;
                }
                d2 = d5;
                ++n2;
            }
        }
        return (double)n * Math.log((double)n / d) + d - (double)n;
    }

    public double dbinom(int n, int n2, double d) {
        if (d == 0.0) {
            return n == 0 ? 1.0 : 0.0;
        }
        if (d == 1.0) {
            return n == n2 ? 1.0 : 0.0;
        }
        if (n == 0) {
            return Math.exp((double)n2 * Math.log(1.0 - d));
        }
        if (n == n2) {
            return Math.exp((double)n2 * Math.log(d));
        }
        if (n < 0 | n > n2) {
            return 0.0;
        }
        double d2 = this.stirlerr(n2) - this.stirlerr(n) - this.stirlerr(n2 - n) - this.bd0(n, (double)n2 * d) - this.bd0(n2 - n, (double)n2 * (1.0 - d));
        return Math.exp(d2) * Math.sqrt((double)n2 / (Math.PI * 2 * (double)n * (double)(n2 - n)));
    }

    public double dhyperg(int n, int n2, int n3, int n4) {
        double d = (double)n3 / (double)n4;
        return this.dbinom(n, n2, d) * this.dbinom(n3 - n, n4 - n2, d) / this.dbinom(n3, n4, d);
    }

    public double SumHGP(int n, int n2, int n3, int n4) {
        if (n4 > n3 || n4 > n2 || n3 > n || n2 > n) {
            return 0.0;
        }
        if (n4 < 1) {
            return 1.0;
        }
        if (n2 < n3) {
            double d = 0.0;
            for (int i = n4; i < n2 + 1; ++i) {
                d += this.dhyperg(i, n3, n2, n);
            }
            return d;
        }
        double d = 0.0;
        for (int i = n4; i < n3 + 1; ++i) {
            d += this.dhyperg(i, n3, n2, n);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        HypergeometricProbability hypergeometricProbability = new HypergeometricProbability();
        System.out.println("p = " + hypergeometricProbability.SumHGP(325, 19, 37, 5));
    }
}

