/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jetty.handlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.ResourceUtil;

public class HomeHandler
extends AbstractHandler {
    private final String header;
    private final String footer;
    private final Matrix matrix = Matrix.Factory.localhostMatrix();

    public HomeHandler() throws IOException {
        this.header = ResourceUtil.getResourceAsString("org/ujmp/jetty/header.html");
        this.footer = ResourceUtil.getResourceAsString("org/ujmp/jetty/footer.html");
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        baseRequest.setHandled(true);
        response.setContentType("text/html; charset=utf-8");
        response.setStatus(200);
        response.getWriter().println(this.header);
        response.getWriter().println("<div class=\"container\">");
        response.getWriter().println("<h1>Home</h1>");
        response.getWriter().println(this.matrix.toHtml());
        response.getWriter().println("</div>");
        response.getWriter().println(this.footer);
        response.getWriter().close();
    }
}

