/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.io.File;
import java.util.Collection;
import org.elasticsearch.client.Client;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.io.FileUtil;
import org.ujmp.elasticsearch.ElasticsearchDataMap;
import org.ujmp.elasticsearch.ElasticsearchIndex;
import org.ujmp.elasticsearch.ElasticsearchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticsearchFileIndex {
    public static final String ID = "_id";
    public static final String META = "meta";
    public static final String DATA = "data";
    private final ElasticsearchDataMap dataMap;
    private final ElasticsearchIndex metaIndex;

    public ElasticsearchFileIndex(String hostname, String index) {
        this(hostname, 9300, index, META, DATA);
    }

    public ElasticsearchFileIndex(String hostname, String index, String metaType, String dataType) {
        this(hostname, 9300, index, metaType, dataType);
    }

    public ElasticsearchFileIndex(String hostname, int port, String index, String metaType, String dataType) {
        this((Client)ElasticsearchUtil.createTransportClient(hostname, port), index, metaType, dataType);
    }

    public ElasticsearchFileIndex(Client client, String index, String metaType, String dataType) {
        this.dataMap = new ElasticsearchDataMap(client, index, dataType);
        this.metaIndex = new ElasticsearchIndex(client, index, metaType);
    }

    public void addFile(File file) throws Exception {
        if (file == null) {
            return;
        }
        DefaultMapMatrix<String, Object> map = new DefaultMapMatrix<String, Object>();
        map.put(ID, file.getAbsolutePath());
        map.put(ID, file.getAbsolutePath());
        map.put("is_file", file.isFile());
        map.put("is_directory", file.isDirectory());
        map.put("length", file.length());
        map.put("last_modified", file.lastModified());
        map.put("delete_time", 0);
        map.put("name", file.getName());
        map.put("can_read", file.canRead());
        map.put("can_write", file.canWrite());
        map.put("can_execute", file.canExecute());
        map.put("parent", file.getParent());
        if (!file.isDirectory()) {
            byte[] data = FileUtil.getBytes(file);
            String id = MathUtil.md5(data);
            this.dataMap.put(id, data);
            map.put("data_id", id);
        }
        this.metaIndex.put(map);
    }

    public Collection<MapMatrix<String, Object>> listFiles() {
        return this.metaIndex.values();
    }
}

