/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix;

public class RemoteObjectMatrixUDP
extends AbstractDenseObjectMatrix {
    private static final long serialVersionUID = 3889079475875267966L;
    private static final int BUFFERSIZE = 512;
    private static final int TIMEOUT = 1000;
    private DatagramPacket receivedPacket = null;
    private DatagramSocket socket = null;
    private SocketAddress destination = null;

    public RemoteObjectMatrixUDP(String server, int port) {
        super(1L, 1L);
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(1000);
            this.destination = new InetSocketAddress(server, port);
            this.receivedPacket = new DatagramPacket(new byte[512], 512);
        }
        catch (Exception e) {
            throw new RuntimeException("could not connnect to matrix", e);
        }
    }

    public synchronized long[] getSize() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(2);
            oos.flush();
            oos.close();
            DatagramPacket sentPacket = new DatagramPacket(bos.toByteArray(), bos.size(), this.destination);
            this.socket.send(sentPacket);
            this.socket.receive(this.receivedPacket);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.receivedPacket.getData()));
            int command = ois.readInt();
            if (command != 2) {
                throw new RuntimeException("could not set value");
            }
            ois.close();
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not send packet", e);
        }
    }

    public synchronized double getAsDouble(long ... coordinates) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(0);
            oos.writeObject(coordinates);
            oos.flush();
            oos.close();
            DatagramPacket sentPacket = new DatagramPacket(bos.toByteArray(), bos.size(), this.destination);
            this.socket.send(sentPacket);
            this.socket.receive(this.receivedPacket);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.receivedPacket.getData()));
            int command = ois.readInt();
            if (command != 0) {
                throw new RuntimeException("could not get value");
            }
            double result = ois.readDouble();
            ois.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("could not send packet", e);
        }
    }

    public synchronized void setAsDouble(double value, long ... coordinates) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(1);
            oos.writeObject(coordinates);
            oos.writeDouble(value);
            oos.flush();
            oos.close();
            DatagramPacket sentPacket = new DatagramPacket(bos.toByteArray(), bos.size(), this.destination);
            this.socket.send(sentPacket);
            this.socket.receive(this.receivedPacket);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.receivedPacket.getData()));
            int command = ois.readInt();
            ois.close();
            if (command != 1) {
                throw new RuntimeException("could not set value");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not send packet", e);
        }
    }

    public Object getObject(long ... coordinates) {
        throw new RuntimeException("not implemented");
    }

    public void setObject(Object o, long ... coordinates) {
        throw new RuntimeException("not implemented");
    }
}

