/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.objectmatrix.ObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.ObjectCalculation;
import org.ujmp.core.objectmatrix.impl.ObjectCalculationMatrix;

public abstract class AbstractObjectCalculation
extends AbstractCalculation
implements ObjectCalculation {
    private static final long serialVersionUID = 7767220107834181824L;

    public AbstractObjectCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractObjectCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final ObjectMatrix calcLink() {
        return new ObjectCalculationMatrix(this);
    }

    public final Matrix calcNew() {
        DenseMatrix result = Matrix.Factory.zeros(this.getValueType(), this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsObject(this.getObject(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsObject(this.getObject(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setObject(Object value, long ... coordinates) {
    }

    public ValueType getValueType() {
        return this.getSource().getValueType();
    }
}

