/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.DoubleCalculation;
import org.ujmp.core.doublematrix.impl.DoubleCalculationMatrix;
import org.ujmp.core.enums.ValueType;

public abstract class AbstractDoubleCalculation
extends AbstractCalculation
implements DoubleCalculation {
    private static final long serialVersionUID = -7509806754731040687L;

    public AbstractDoubleCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractDoubleCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public DoubleMatrix calcLink() {
        return new DoubleCalculationMatrix(this);
    }

    public Matrix calcNew() {
        DenseDoubleMatrix2D result = DoubleMatrix2D.Factory.zeros(this.getSize()[0], this.getSize()[1]);
        for (long[] c : result.allCoordinates()) {
            result.setAsDouble(this.getDouble(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        Matrix matrix = this.getSource();
        for (long[] c : this.getSource().allCoordinates()) {
            matrix.setAsDouble(this.getDouble(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setDouble(double value, long ... coordinates) {
    }

    public final ValueType getValueType() {
        return ValueType.DOUBLE;
    }
}

