/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.calculation.AbstractBooleanCalculation;

public class And
extends AbstractBooleanCalculation {
    private static final long serialVersionUID = -2181584777964801120L;

    public And(Matrix m1, Matrix m2) {
        super(m1, m2);
        if (m2.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[1] = Matrix.Factory.fill(m2.getAsBoolean(0L, 0L), m1.getSize());
        } else if (m1.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[0] = Matrix.Factory.fill(m1.getAsBoolean(0L, 0L), m2.getSize());
        }
    }

    public And(Matrix m1, boolean v2) {
        this(m1, (Matrix)Matrix.Factory.fill(v2, m1.getSize()));
    }

    public And(boolean v1, Matrix m2) {
        this((Matrix)Matrix.Factory.fill(v1, m2.getSize()), m2);
    }

    public boolean getBoolean(long ... coordinates) {
        return this.getSource().getAsBoolean(coordinates) && this.getSources()[1].getAsBoolean(coordinates);
    }
}

