/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AdvancedFTPSettings;
import com.enterprisedt.net.ftp.AdvancedGeneralSettings;
import com.enterprisedt.net.ftp.AutoCloseFileTransferInputStream;
import com.enterprisedt.net.ftp.AutoCloseFileTransferOutputStream;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.internal.ConnectionContext;
import com.enterprisedt.net.ftp.internal.EventAggregator;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

public class FileTransferClient
implements FileTransferClientInterface {
    private static Logger log = Logger.getLogger("FileTransferClient");
    protected ConnectionContext masterContext = new ConnectionContext();
    protected EventAggregator eventAggregator = null;
    protected EventListener listener;
    private FTPClient ftpClient = new FTPClient();
    private AdvancedFTPSettings advancedFTPSettings = new AdvancedFTPSettings(this.masterContext);
    private AdvancedGeneralSettings advancedSettings = new AdvancedGeneralSettings(this.masterContext);
    private FileStatistics statistics = new FileStatistics();

    public FileTransferClient() {
        this.statistics.addClient(this.ftpClient);
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.isConnected()) {
            throw new FTPException("The file transfer client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.isConnected()) {
            throw new FTPException("The file transfer client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    public synchronized boolean isConnected() {
        return this.ftpClient.connected();
    }

    public synchronized String getRemoteHost() {
        return this.masterContext.getRemoteHost();
    }

    public synchronized void setRemoteHost(String remoteHost) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemoteHost(remoteHost);
    }

    public synchronized int getTimeout() {
        return this.masterContext.getTimeout();
    }

    public synchronized void setTimeout(int timeout) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setTimeout(timeout);
    }

    public synchronized int getNetworkBufferSize() {
        return this.masterContext.getNetworkBufferSize();
    }

    public synchronized void setNetworkBufferSize(int networkBufferSize) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setNetworkBufferSize(networkBufferSize);
    }

    public synchronized int getRemotePort() {
        return this.masterContext.getRemotePort();
    }

    public synchronized void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemotePort(remotePort);
    }

    public synchronized void setContentType(FTPTransferType type) throws IOException, FTPException {
        this.masterContext.setContentType(type);
        if (this.ftpClient != null && this.ftpClient.connected()) {
            this.ftpClient.setType(type);
        }
    }

    public synchronized FTPTransferType getContentType() {
        return this.masterContext.getContentType();
    }

    public void setDetectContentType(boolean detectContentType) {
        this.masterContext.setDetectContentType(detectContentType);
        if (this.ftpClient != null) {
            this.ftpClient.setDetectTransferMode(detectContentType);
        }
    }

    public boolean isDetectContentType() {
        return this.masterContext.getDetectContentType();
    }

    public synchronized void setUserName(String userName) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setUserName(userName);
    }

    public synchronized String getPassword() {
        return this.masterContext.getPassword();
    }

    public synchronized void setPassword(String password) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setPassword(password);
    }

    public synchronized String getUserName() {
        return this.masterContext.getUserName();
    }

    public synchronized AdvancedFTPSettings getAdvancedFTPSettings() {
        return this.advancedFTPSettings;
    }

    public synchronized AdvancedGeneralSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    public synchronized void setEventListener(EventListener listener) {
        this.listener = listener;
        this.eventAggregator = new EventAggregator(listener);
        if (this.ftpClient != null) {
            this.eventAggregator.setConnId(this.ftpClient.getId());
            this.ftpClient.setMessageListener(this.eventAggregator);
            this.ftpClient.setProgressMonitor(this.eventAggregator);
            this.ftpClient.setProgressMonitorEx(this.eventAggregator);
        }
    }

    public synchronized void connect() throws FTPException, IOException {
        if (this.eventAggregator != null) {
            this.eventAggregator.setConnId(this.ftpClient.getId());
            this.ftpClient.setMessageListener(this.eventAggregator);
            this.ftpClient.setProgressMonitor(this.eventAggregator);
            this.ftpClient.setProgressMonitorEx(this.eventAggregator);
        }
        this.statistics.clear();
        this.configureClient();
        log.debug("Configured client");
        this.ftpClient.connect();
        log.debug("Client connected");
        if (this.masterContext.isAutoLogin()) {
            log.debug("Logging in");
            this.ftpClient.login(this.masterContext.getUserName(), this.masterContext.getPassword());
            log.debug("Logged in");
            this.configureTransferType(this.masterContext.getContentType());
        } else {
            log.debug("Manual login enabled");
        }
    }

    public void manualLogin() throws FTPException, IOException {
        this.checkConnection(true);
        log.debug("Logging in");
        this.ftpClient.login(this.masterContext.getUserName(), this.masterContext.getPassword());
        log.debug("Logged in");
        this.configureTransferType(this.masterContext.getContentType());
    }

    private void configureClient() throws IOException, FTPException {
        this.ftpClient.setRemoteHost(this.masterContext.getRemoteHost());
        this.ftpClient.setRemotePort(this.masterContext.getRemotePort());
        this.ftpClient.setTimeout(this.masterContext.getTimeout());
        this.ftpClient.setNetworkBufferSize(this.masterContext.getNetworkBufferSize());
        this.ftpClient.setRetryCount(this.masterContext.getRetryCount());
        this.ftpClient.setRetryDelay(this.masterContext.getRetryDelay());
        this.ftpClient.setControlEncoding(this.masterContext.getControlEncoding());
        this.ftpClient.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.ftpClient.setFileLockingEnabled(this.masterContext.getFileLockingEnabled());
        this.ftpClient.setConnectMode(this.masterContext.getConnectMode());
        this.ftpClient.setParserLocales(this.masterContext.getParserLocales());
        this.ftpClient.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        this.ftpClient.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        this.ftpClient.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        this.ftpClient.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        this.ftpClient.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        this.ftpClient.setFileNotFoundMessages(this.masterContext.getFileNotFoundMessages());
        this.ftpClient.setDirectoryEmptyMessages(this.masterContext.getDirectoryEmptyMessages());
        this.ftpClient.setTransferCompleteMessages(this.masterContext.getTransferCompleteMessages());
        if (this.masterContext.getActiveHighPort() >= 0 && this.masterContext.getActiveLowPort() >= 0) {
            this.ftpClient.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void configureTransferType(FTPTransferType type) throws IOException, FTPException {
        this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.ftpClient.setType(type);
    }

    private void checkTransferSettings() throws FTPException {
        if (this.ftpClient.getDetectTransferMode() != this.masterContext.getDetectContentType()) {
            this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        }
        if (this.ftpClient.isStrictReturnCodes() != this.masterContext.isStrictReturnCodes()) {
            this.ftpClient.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        }
        if (!this.ftpClient.getConnectMode().equals(this.masterContext.getConnectMode())) {
            this.ftpClient.setConnectMode(this.masterContext.getConnectMode());
        }
        if (this.ftpClient.isAutoPassiveIPSubstitution() != this.masterContext.isAutoPassiveIPSubstitution()) {
            this.ftpClient.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        }
        if (this.ftpClient.isDeleteOnFailure() != this.masterContext.isDeleteOnFailure()) {
            this.ftpClient.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        }
        if (this.ftpClient.getActiveIPAddress() != this.masterContext.getActiveIPAddress()) {
            this.ftpClient.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        }
        if (this.ftpClient.getTransferBufferSize() != this.masterContext.getTransferBufferSize()) {
            this.ftpClient.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        }
        if (this.ftpClient.getMonitorInterval() != (long)this.masterContext.getTransferNotifyInterval()) {
            this.ftpClient.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        }
        if (this.masterContext.getActiveHighPort() != this.ftpClient.getActiveHighPort() || this.masterContext.getActiveLowPort() != this.ftpClient.getActiveLowPort()) {
            this.ftpClient.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void checkListingSettings() throws FTPException {
        this.ftpClient.setParserLocales(this.masterContext.getParserLocales());
        this.checkTransferSettings();
    }

    protected static void prepareURLTransfer(URL url, FileTransferClientInterface client) throws IOException, FTPException {
        String TYPE;
        String query;
        int typePos;
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        client.setRemoteHost(url.getHost());
        if (url.getPort() > 0) {
            client.setRemotePort(url.getPort());
        }
        String userInfo = url.getUserInfo();
        String userName = "anonymous";
        String password = "";
        if (userInfo != null) {
            int colonPos = userInfo.indexOf(58);
            if (colonPos >= 0) {
                userName = userInfo.substring(0, colonPos);
                if (colonPos + 1 < userInfo.length() - 1) {
                    password = userInfo.substring(colonPos + 1);
                }
            } else {
                userName = userInfo;
            }
        }
        client.setUserName(userName);
        client.setPassword(password);
        client.setDetectContentType(true);
        if (url.getQuery() != null && (typePos = (query = url.getQuery()).indexOf(TYPE = "type=")) >= 0 && query.length() > typePos + TYPE.length()) {
            char typeChar = query.toUpperCase().charAt(typePos + TYPE.length());
            if (typeChar == FTPTransferType.BINARY_CHAR.charAt(0)) {
                client.setContentType(FTPTransferType.BINARY);
                client.setDetectContentType(true);
            } else if (typeChar == FTPTransferType.ASCII_CHAR.charAt(0)) {
                client.setContentType(FTPTransferType.ASCII);
                client.setDetectContentType(true);
            } else {
                throw new MalformedURLException("Unknown type: " + query.substring(typePos));
            }
        }
    }

    public synchronized FileStatistics getStatistics() {
        return this.statistics;
    }

    public synchronized String executeCommand(String command) throws FTPException, IOException {
        return this.ftpClient.quote(command);
    }

    public void cancelAllTransfers() {
        log.debug("cancelAllTransfers() called");
        this.ftpClient.cancelTransfer();
    }

    public FTPReply getLastReply() {
        return this.ftpClient.getLastReply();
    }

    public synchronized String getSystemType() throws FTPException, IOException {
        return this.ftpClient.system();
    }

    public synchronized String[] directoryNameList() throws FTPException, IOException {
        return this.directoryNameList("", false);
    }

    public synchronized String[] directoryNameList(String directoryName, boolean isLongListing) throws FTPException, IOException {
        this.checkListingSettings();
        return this.ftpClient.dir(directoryName, isLongListing);
    }

    public synchronized FTPFile[] directoryList() throws FTPException, IOException, ParseException {
        return this.directoryList("");
    }

    public synchronized FTPFile[] directoryList(String directoryName) throws FTPException, IOException, ParseException {
        this.checkListingSettings();
        return this.ftpClient.dirDetails(directoryName);
    }

    public synchronized void directoryList(String directoryName, DirectoryListCallback lister) throws FTPException, IOException, ParseException {
        this.checkListingSettings();
        this.ftpClient.dirDetails(directoryName, lister);
    }

    public synchronized byte[] downloadByteArray(String remoteFileName) throws FTPException, IOException {
        this.checkTransferSettings();
        return this.ftpClient.get(remoteFileName);
    }

    public synchronized void downloadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        this.downloadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    public synchronized void downloadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.checkTransferSettings();
        if (writeMode.equals(WriteMode.RESUME)) {
            this.ftpClient.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            throw new FTPException("Append not permitted for downloads");
        }
        this.ftpClient.get(localFileName, remoteFileName);
    }

    public static FileTransferInputStream downloadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL url = new URL(ftpURL);
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        FileTransferClient client = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(url, client);
        client.connect();
        return new AutoCloseFileTransferInputStream(client.downloadStream(url.getPath()), client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL url = new URL(ftpURL);
        FileTransferClient client = new FileTransferClient();
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(url, client);
        client.connect();
        try {
            client.downloadFile(localFileName, url.getPath());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            client.disconnect();
            throw throwable;
        }
        client.disconnect();
    }

    public synchronized FileTransferInputStream downloadStream(String remoteFileName) throws FTPException, IOException {
        this.checkTransferSettings();
        return new FTPInputStream(this.ftpClient, remoteFileName);
    }

    public synchronized String uploadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        return this.uploadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    public synchronized String uploadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.checkTransferSettings();
        boolean append = false;
        if (writeMode.equals(WriteMode.RESUME)) {
            this.ftpClient.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            append = true;
        }
        return this.ftpClient.put(localFileName, remoteFileName, append);
    }

    public synchronized FileTransferOutputStream uploadStream(String remoteFileName) throws FTPException, IOException {
        return this.uploadStream(remoteFileName, WriteMode.OVERWRITE);
    }

    public synchronized FileTransferOutputStream uploadStream(String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.checkTransferSettings();
        if (WriteMode.RESUME.equals(writeMode)) {
            throw new FTPException("Resume not supported for stream uploads");
        }
        boolean append = WriteMode.APPEND.equals(writeMode);
        return new FTPOutputStream(this.ftpClient, remoteFileName, append);
    }

    public static FileTransferOutputStream uploadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL url = new URL(ftpURL);
        FileTransferClient client = new FileTransferClient();
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(url, client);
        client.connect();
        return new AutoCloseFileTransferOutputStream(client.uploadStream(url.getPath()), client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL url = new URL(ftpURL);
        FileTransferClient client = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(url, client);
        client.connect();
        try {
            client.uploadFile(localFileName, url.getPath());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            client.disconnect();
            throw throwable;
        }
        client.disconnect();
    }

    public synchronized long getSize(String remoteFileName) throws FTPException, IOException {
        return this.ftpClient.size(remoteFileName);
    }

    public synchronized Date getModifiedTime(String remoteFileName) throws FTPException, IOException {
        return this.ftpClient.modtime(remoteFileName);
    }

    public synchronized void setModifiedTime(String remoteFileName, Date modifiedTime) throws FTPException, IOException {
        this.ftpClient.setModTime(remoteFileName, modifiedTime);
    }

    public synchronized boolean exists(String remoteFileName) throws FTPException, IOException {
        return this.ftpClient.exists(remoteFileName);
    }

    public synchronized void deleteFile(String remoteFileName) throws FTPException, IOException {
        this.ftpClient.delete(remoteFileName);
    }

    public synchronized void rename(String renameFromName, String renameToName) throws FTPException, IOException {
        this.ftpClient.rename(renameFromName, renameToName);
    }

    public synchronized void changeDirectory(String directoryName) throws FTPException, IOException {
        this.ftpClient.chdir(directoryName);
    }

    public synchronized void changeToParentDirectory() throws FTPException, IOException {
        this.ftpClient.cdup();
    }

    public synchronized String getRemoteDirectory() throws IOException, FTPException {
        return this.ftpClient.pwd();
    }

    public synchronized void createDirectory(String directoryName) throws FTPException, IOException {
        this.ftpClient.mkdir(directoryName);
    }

    public synchronized void deleteDirectory(String directoryName) throws FTPException, IOException {
        this.ftpClient.rmdir(directoryName);
    }

    public synchronized void disconnect() throws FTPException, IOException {
        this.ftpClient.quit();
    }

    public synchronized void disconnect(boolean immediate) throws FTPException, IOException {
        if (immediate) {
            this.ftpClient.quitImmediately();
        } else {
            this.ftpClient.quit();
        }
    }
}

