/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;

public class Translate
extends AbstractStringCalculation {
    private static final long serialVersionUID = -4472157760970152847L;
    private Method method = null;
    private String targetLanguage;
    private String sourceLanguage;

    public Translate(Matrix m, String sourceLanguage, String targetLanguage) {
        super(m);
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        try {
            Class<?> translator = Class.forName("org.ujmp.googletranslate.GoogleTranslate");
            this.method = translator.getMethod("translateString", String.class, String.class, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("translation not supported. needs ujmp-googletranslate");
        }
    }

    public String getString(long ... coordinates) {
        String s = this.getSource().getAsString(coordinates);
        if (s == null || this.method == null) {
            return null;
        }
        try {
            return (String)this.method.invoke(null, this.sourceLanguage, this.targetLanguage, s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

